package de.ugoe.cs.eventbench.commands;
import java.security.InvalidParameterException;
import java.util.List;

import de.ugoe.cs.eventbench.data.GlobalDataContainer;
import de.ugoe.cs.eventbench.markov.MarkovModel;
import de.ugoe.cs.util.console.Command;
import de.ugoe.cs.util.console.Console;


public class CMDcalcEntropy implements Command {

	@Override
	public void help() {
		Console.println("Usage: calcEntropy <modelname>");
	}

	@Override
	public void run(List<Object> parameters) {
		String modelname = "";
		try {
			modelname = (String) parameters.get(0);
		} catch (Exception e) {
			throw new InvalidParameterException();
		}
		
		MarkovModel model = null; 
		Object dataObject = GlobalDataContainer.getInstance().getData(modelname);
		if( dataObject==null ) {
			Console.println("Model " + modelname + "not found in storage.");
		}
		else if( !(dataObject instanceof MarkovModel) ) {
			Console.println("Object " + modelname + " is not a markov model!");
		} else {
			model = (MarkovModel) dataObject;
			double entropy = model.calcEntropy();
			if( Double.isNaN(entropy) ) {
				Console.println("entropy: " + entropy);
			}
		}
	}

}
