package de.ugoe.cs.util.console.defaultcommands;

import java.util.List;

import de.ugoe.cs.util.console.Command;
import de.ugoe.cs.util.console.Console;

/**
 * <p>
 * Implements a command to terminate an application.
 * </p>
 * 
 * @author Steffen Herbold
 *
 */
public class CMDexit implements Command {

	/* (non-Javadoc)
	 * @see databasebuilder.console.commands.Command#help()
	 */
	@Override
	public void help() {
		Console.println("Usage: exit");
	}
	
	/**
	 * <p>
	 * Terminates the programm.
	 * </p>
	 * <p>
	 * Usage: <code>exit</code>
	 * </p>
	 */
	@Override
	public void run(List<Object> parameters) {
		System.exit(0);
	}

}
