package de.ugoe.cs.eventbench.commands;

import java.security.InvalidParameterException;
import java.util.List;
import java.util.Random;

import de.ugoe.cs.eventbench.data.Event;
import de.ugoe.cs.eventbench.data.GlobalDataContainer;
import de.ugoe.cs.eventbench.ppm.PredictionByPartialMatch;
import de.ugoe.cs.util.console.Command;
import de.ugoe.cs.util.console.Console;

public class CMDtrainPPM implements Command {

	@Override
	public void help() {
		Console.println("Usage: trainPPM <modelName> <order>");
	}

	@SuppressWarnings("unchecked")
	@Override
	public void run(List<Object> parameters) {
		String modelname;
		int order;
		try {
			modelname = (String) parameters.get(0);
			order = Integer.parseInt((String) parameters.get(1));
		} catch (Exception e) {
			throw new InvalidParameterException();
		}
		
		List<List<Event<?>>> sequences = null;
		Object dataObject = GlobalDataContainer.getInstance().getData("sequences");
			
		try {
			sequences = (List<List<Event<?>>>) dataObject;
			if( sequences.size()>0 ) {
				if( sequences.get(0).get(0) instanceof Event ) {
					PredictionByPartialMatch model = new PredictionByPartialMatch(order, new Random());
					model.train(sequences);
					if( GlobalDataContainer.getInstance().addData(modelname, model) ) {
						Console.traceln("Old model overwritten");
					}
					// TODO TMP!!
					Console.traceln(model.randomSequence().toString());
					
				} else {
					Console.traceln("Illegal use of \"sequences\" parameter in the GlobalDataContainer.");
					Console.traceln("The parameter should always be of type List<List<Event>>!");
				}
			}
		}
		catch(ClassCastException e) {
			Console.println("Sequences need to be loaded first using parseXML");
		}
	}

}
