package de.ugoe.cs.eventbench.messagehandler;

import de.ugoe.cs.eventbench.data.WindowTree;

public class HandlerDestroy extends MessageHandler {

	public HandlerDestroy() {
		super();
	}

	private int hwnd;
	
	@Override
	public void onEndElement() {
		if( hwnd!=0 ) {
			WindowTree.getInstance().remove(hwnd);
		}
	}

	@Override
	public void onParameter(String name, String value) {
		if( name.equals("window.hwnd") ) {
			hwnd = Integer.parseInt(value);
		}
	}

	@Override
	public void onStartElement() {
		hwnd = 0;
	}

}
