package de.ugoe.cs.eventbench.commands;

import java.security.InvalidParameterException;
import java.util.List;

import de.ugoe.cs.eventbench.data.GlobalDataContainer;
import de.ugoe.cs.eventbench.models.IStochasticProcess;
import de.ugoe.cs.util.console.Command;
import de.ugoe.cs.util.console.Console;

public class CMDnumStates implements Command {

	@Override
	public void run(List<Object> parameters) {
		String modelname = "";
		try {
			modelname = (String) parameters.get(0);
		} catch (Exception e) {
			throw new InvalidParameterException();
		}
		
		IStochasticProcess model = null; 
		Object dataObject = GlobalDataContainer.getInstance().getData(modelname);
		if( dataObject==null ) {
			Console.println("Model " + modelname + "not found in storage.");
		}
		else if( !(dataObject instanceof IStochasticProcess) ) {
			Console.println("Object " + modelname + " is not a stochastic process!");
		} else {
			model = (IStochasticProcess) dataObject;
			Console.println("" + model.getNumStates() + " states");
		}
	}

	@Override
	public void help() {
		Console.println("Usage: numStates <modelName>");
	}

}
