#ifndef __USERLOG_H__
#define __USERLOG_H__

#ifdef USERLOG_EXPORTS
#define USERLOG_API __declspec(dllexport)
#else
#define USERLOG_API __declspec(dllimport)
#endif

#include <iostream>
#include <fstream>



//#define __USING_MTRACE__
#define __USING_COSTUMLOG__
#define __INCLUDEHOOKINFO__
//#define __TIMING__
#define __ENCODE_BASE64__

#define LOGPREFIX " UL: "
#define LOGPREFIXCONT " ULC: "
#define LOGPREFIXWSTRING L" UL: "

#define NUMHOOKS 2

#define CALLWNDHOOKID 0
#define GETMSGHOOKID 1

#ifdef __USING_COSTUMLOG__
#define LOGFILE "usagelog.txt"
#endif

typedef struct _HOOKDATA {
	int nType;
	HOOKPROC hkproc;
	HHOOK hookhandle;
	bool active;
} HOOKDATA;

HOOKDATA myhookdata[NUMHOOKS];

#ifdef __cplusplus
extern "C" {
#endif

/**
 * API function that starts the logging of messages. 
 * All required hooks and logging mechanisms are initialized. 
 */
USERLOG_API void __cdecl InitUsagelog();

/**
 * API function that stopts the logging of messages. 
 * All existing hooks are released and if required, logging mechnisms are stopped.
 */
USERLOG_API void __cdecl ReleaseUsagelog();

#ifdef __cplusplus
} // extern "C"
#endif


void InitHookdata();

void InitHooks();

void ReleaseHooks();


LRESULT CALLBACK CallWndProc(int nCode, WPARAM wParam, LPARAM lParam);

LRESULT CALLBACK GetMsgProc(int nCode, WPARAM wParam, LPARAM lParam);

void HookProc(int nFrom, int nCode, PMSG msg);

void WriteLogentryWString(PMSG msg, int nFrom);

#ifdef __USING_COSTUMLOG__
void InitLogfile();

void CloseLogfile();
#endif

#endif // __USERLOG_H__