/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.ArrayList;
import javax.media.j3d.GeometryStripArrayRetained;
import javax.media.j3d.IndexedGeometryArrayRetained;
import javax.media.j3d.IndexedLineStripArrayRetained;
import javax.media.j3d.IndexedTriangleFanArrayRetained;
import javax.media.j3d.IndexedTriangleStripArrayRetained;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.LineStripArrayRetained;
import javax.media.j3d.TriangleFanArrayRetained;
import javax.media.j3d.TriangleStripArrayRetained;

abstract class IndexedGeometryStripArrayRetained
extends IndexedGeometryArrayRetained {
    int[] stripIndexCounts;
    int[] compileStripICOffset;
    int[] compileIndexLength;

    IndexedGeometryStripArrayRetained() {
    }

    void setStripIndexCounts(int[] nArray) {
        int n = nArray.length;
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            n2 += nArray[n3];
            if (this instanceof IndexedLineStripArrayRetained) {
                if (nArray[n3] < 2) {
                    throw new IllegalArgumentException(J3dI18N.getString("IndexedLineStripArrayRetained1"));
                }
            } else if (this instanceof IndexedTriangleStripArrayRetained) {
                if (nArray[n3] < 3) {
                    throw new IllegalArgumentException(J3dI18N.getString("IndexedTriangleStripArrayRetained1"));
                }
            } else if (this instanceof IndexedTriangleFanArrayRetained && nArray[n3] < 3) {
                throw new IllegalArgumentException(J3dI18N.getString("IndexedTriangleFanArrayRetained1"));
            }
            ++n3;
        }
        if (this.initialIndexIndex + n2 > this.indexCount) {
            throw new IllegalArgumentException(J3dI18N.getString("IndexedGeometryStripArrayRetained0"));
        }
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int[] nArray2 = null;
        n4 = this.computeMaxIndex(this.initialIndexIndex, n2, this.indexCoord);
        this.doErrorCheck(n4);
        if ((this.vertexFormat & 0x200) == 0) {
            if ((this.vertexFormat & 4) != 0) {
                n5 = this.computeMaxIndex(this.initialIndexIndex, n2, this.indexColor);
                this.doColorCheck(n5);
            }
            if ((this.vertexFormat & 0x460) != 0) {
                nArray2 = new int[this.texCoordSetCount];
                n3 = 0;
                while (n3 < this.texCoordSetCount) {
                    nArray2[n3] = this.computeMaxIndex(this.initialIndexIndex, n2, (int[])this.indexTexCoord[n3]);
                    this.doTexCoordCheck(nArray2[n3], n3);
                    ++n3;
                }
            }
            if ((this.vertexFormat & 2) != 0) {
                n6 = this.computeMaxIndex(this.initialIndexIndex, n2, this.indexNormal);
                this.doNormalCheck(n6);
            }
        }
        this.geomLock.getLock();
        this.validIndexCount = n2;
        this.stripIndexCounts = new int[n];
        n3 = 0;
        while (n3 < n) {
            this.stripIndexCounts[n3] = nArray[n3];
            ++n3;
        }
        this.maxCoordIndex = n4;
        if ((this.vertexFormat & 0x200) == 0) {
            this.maxColorIndex = n5;
            if ((this.vertexFormat & 0x460) != 0) {
                n3 = 0;
                while (n3 < this.texCoordSetCount) {
                    this.maxTexCoordIndices[n3] = nArray2[n3];
                    ++n3;
                }
            }
            this.maxNormalIndex = n6;
        } else {
            this.maxColorIndex = this.maxCoordIndex;
            this.maxNormalIndex = this.maxCoordIndex;
            if ((this.vertexFormat & 0x460) != 0) {
                n3 = 0;
                while (n3 < this.texCoordSetCount) {
                    this.maxTexCoordIndices[n3] = this.maxCoordIndex;
                    ++n3;
                }
            }
        }
        this.geomLock.unLock();
        if (!this.inUpdater && this.source != null && this.source.isLive()) {
            this.sendDataChangedMessage(true);
        }
    }

    Object cloneNonIndexedGeometry() {
        GeometryStripArrayRetained geometryStripArrayRetained = null;
        switch (this.geoType) {
            case 14: {
                geometryStripArrayRetained = new LineStripArrayRetained();
                break;
            }
            case 13: {
                geometryStripArrayRetained = new TriangleFanArrayRetained();
                break;
            }
            case 12: {
                geometryStripArrayRetained = new TriangleStripArrayRetained();
            }
        }
        geometryStripArrayRetained.createGeometryArrayData(this.validIndexCount, this.vertexFormat & 0xFFFFF67F, this.texCoordSetCount, this.texCoordSetMap);
        geometryStripArrayRetained.unIndexify(this);
        geometryStripArrayRetained.setStripVertexCounts(this.stripIndexCounts);
        return geometryStripArrayRetained;
    }

    int getNumStrips() {
        return this.stripIndexCounts.length;
    }

    void getStripIndexCounts(int[] nArray) {
        int n = nArray.length - 1;
        while (n >= 0) {
            nArray[n] = this.stripIndexCounts[n];
            --n;
        }
    }

    void mergeGeometryArrays(ArrayList arrayList) {
        int n = arrayList.size();
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            IndexedGeometryStripArrayRetained indexedGeometryStripArrayRetained = (IndexedGeometryStripArrayRetained)arrayList.get(n3);
            n2 += indexedGeometryStripArrayRetained.stripIndexCounts.length;
            ++n3;
        }
        this.stripIndexCounts = new int[n2];
        this.compileIndexLength = new int[n2];
        this.compileStripICOffset = new int[n];
        int n4 = 0;
        n3 = 0;
        while (n3 < n) {
            IndexedGeometryStripArrayRetained indexedGeometryStripArrayRetained = (IndexedGeometryStripArrayRetained)arrayList.get(n3);
            this.compileStripICOffset[n3] = n4;
            this.compileIndexLength[n3] = indexedGeometryStripArrayRetained.stripIndexCounts.length;
            System.arraycopy(indexedGeometryStripArrayRetained.stripIndexCounts, 0, this.stripIndexCounts, n4, indexedGeometryStripArrayRetained.stripIndexCounts.length);
            n4 += indexedGeometryStripArrayRetained.stripIndexCounts.length;
            ++n3;
        }
        super.mergeGeometryArrays(arrayList);
    }

    int getNumStrips(int n) {
        return this.compileIndexLength[n];
    }

    void getStripIndexCounts(int n, int[] nArray) {
        int n2 = this.compileIndexLength[n];
        int n3 = this.compileStripICOffset[n];
        int n4 = 0;
        while (n4 < n2) {
            nArray[n4] = this.stripIndexCounts[n3 + 1];
            ++n4;
        }
    }
}

