//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.tasktrees.nodeequality;

import static org.junit.Assert.*;

import org.junit.Test;

import de.ugoe.cs.autoquest.tasktrees.nodeequality.NodeEquality;

/**
 * @author Patrick Harms
 */
public class NodeEqualityTest {

    /**
     *
     */
    @Test
    public void test() {
        assertTrue(NodeEquality.IDENTICAL.isAtLeast(NodeEquality.IDENTICAL));
        assertTrue(NodeEquality.IDENTICAL.isAtLeast(NodeEquality.LEXICALLY_EQUAL));
        assertTrue(NodeEquality.IDENTICAL.isAtLeast(NodeEquality.SYNTACTICALLY_EQUAL));
        assertTrue(NodeEquality.IDENTICAL.isAtLeast(NodeEquality.SEMANTICALLY_EQUAL));
        assertFalse(NodeEquality.IDENTICAL.isAtLeast(NodeEquality.UNEQUAL));

        assertFalse(NodeEquality.LEXICALLY_EQUAL.isAtLeast(NodeEquality.IDENTICAL));
        assertTrue(NodeEquality.LEXICALLY_EQUAL.isAtLeast(NodeEquality.LEXICALLY_EQUAL));
        assertTrue(NodeEquality.LEXICALLY_EQUAL.isAtLeast(NodeEquality.SYNTACTICALLY_EQUAL));
        assertTrue(NodeEquality.LEXICALLY_EQUAL.isAtLeast(NodeEquality.SEMANTICALLY_EQUAL));
        assertFalse(NodeEquality.LEXICALLY_EQUAL.isAtLeast(NodeEquality.UNEQUAL));

        assertFalse(NodeEquality.SYNTACTICALLY_EQUAL.isAtLeast(NodeEquality.IDENTICAL));
        assertFalse(NodeEquality.SYNTACTICALLY_EQUAL.isAtLeast(NodeEquality.LEXICALLY_EQUAL));
        assertTrue(NodeEquality.SYNTACTICALLY_EQUAL.isAtLeast(NodeEquality.SYNTACTICALLY_EQUAL));
        assertTrue(NodeEquality.SYNTACTICALLY_EQUAL.isAtLeast(NodeEquality.SEMANTICALLY_EQUAL));
        assertFalse(NodeEquality.SYNTACTICALLY_EQUAL.isAtLeast(NodeEquality.UNEQUAL));

        assertFalse(NodeEquality.SEMANTICALLY_EQUAL.isAtLeast(NodeEquality.IDENTICAL));
        assertFalse(NodeEquality.SEMANTICALLY_EQUAL.isAtLeast(NodeEquality.LEXICALLY_EQUAL));
        assertFalse(NodeEquality.SEMANTICALLY_EQUAL.isAtLeast(NodeEquality.SYNTACTICALLY_EQUAL));
        assertTrue(NodeEquality.SEMANTICALLY_EQUAL.isAtLeast(NodeEquality.SEMANTICALLY_EQUAL));
        assertFalse(NodeEquality.SEMANTICALLY_EQUAL.isAtLeast(NodeEquality.UNEQUAL));

        assertFalse(NodeEquality.UNEQUAL.isAtLeast(NodeEquality.IDENTICAL));
        assertFalse(NodeEquality.UNEQUAL.isAtLeast(NodeEquality.LEXICALLY_EQUAL));
        assertFalse(NodeEquality.UNEQUAL.isAtLeast(NodeEquality.SYNTACTICALLY_EQUAL));
        assertFalse(NodeEquality.UNEQUAL.isAtLeast(NodeEquality.SEMANTICALLY_EQUAL));
        assertTrue(NodeEquality.UNEQUAL.isAtLeast(NodeEquality.UNEQUAL));
    }

}
