package de.ugoe.cs.autoquest.tasktrees.nodeequality;

import de.ugoe.cs.autoquest.tasktrees.treeifc.IEventTask;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskTreeNode;

/**
 * <p>
 * This rule identifies two task tree nodes as lexically equal, if they are both event tasks and
 * if their respective event types and targets equal. 
 * </p>
 * 
 * @author Patrick Harms
 */
public class EventTaskComparisonRule implements NodeComparisonRule {
    
    /*
     * (non-Javadoc)
     * 
     * @see de.ugoe.cs.tasktree.nodeequality.NodeEqualityRule#apply(TaskTreeNode, TaskTreeNode)
     */
    @Override
    public NodeEquality compare(ITaskTreeNode node1, ITaskTreeNode node2) {
        if ((!(node1 instanceof IEventTask)) || (!(node2 instanceof IEventTask))) {
            return null;
        }

        if (node1 == node2) {
            return NodeEquality.IDENTICAL;
        }

        IEventTask task1 = (IEventTask) node1;
        IEventTask task2 = (IEventTask) node2;
        
        if (task1.getEventType().equals(task2.getEventType()) &&
            task1.getEventTarget().equals(task2.getEventTarget()))
        {
            return NodeEquality.LEXICALLY_EQUAL;
        }
        else {
            return NodeEquality.UNEQUAL;
        }
    }

}
