//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.eventcore.guimodel;

import de.ugoe.cs.autoquest.eventcore.IEventTarget;

/**
 * <p>
 * Common interface for all GUI elements.
 * </p>
 * 
 * @version 1.0
 * @author Patrick Harms
 */
public interface IGUIElement extends IEventTarget {
	/**
	 * <p>
	 * Returns a boolean that indicates if GUIElement was used or not
	 * during a session
	 * </p>
	 * @return
	 */
	public boolean getUsageObserved();

    /**
     * <p>
     * Returns the specification of the GUI element.
     * </p>
     * 
     * @return the specification
     */
    public IGUIElementSpec getSpecification();

    /**
     * <p>
     * Returns the parent of the GUI element.
     * </p>
     * 
     * @return the parent
     */
    public IGUIElement getParent();

    /**
     * <p>
     * Defines that {@link IGUIElement} implementations have to define equals.
     * </p>
     * 
     * @see Object#equals(Object)
     */
    @Override
    public boolean equals(Object other);

    /**
     * <p>
     * Defines that {@link IGUIElement} implementations have to define hashCode.
     * </p>
     * 
     * @see Object#hashCode()
     */
    @Override
    public int hashCode();

    /**
     * <p>
     * Updates the specification of a GUI element with another specification, e.g., to add further
     * known names of the GUI element.
     * </p>
     * 
     * @param furtherSpec
     *            additional specification
     */
    public void updateSpecification(IGUIElementSpec furtherSpec);

    /**
     * <p>
     * The {@link IGUIElement} that is passed by this function is equal to the current GUI element
     * and will hereafter be treated as such.
     * </p>
     * 
     * @param guiElement
     *            GUI element that is equal
     */
    public void addEqualGUIElement(IGUIElement equalElement);
}
