/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.Hashtable;
import javax.media.j3d.Appearance;
import javax.media.j3d.Bounds;
import javax.media.j3d.CapabilityNotSetException;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.Leaf;
import javax.media.j3d.MorphRetained;
import javax.media.j3d.Node;
import javax.media.j3d.PickPoint;
import javax.media.j3d.PickRay;
import javax.media.j3d.PickShape;
import javax.media.j3d.SceneGraphPath;

public class Morph
extends Leaf {
    public static final int ALLOW_GEOMETRY_ARRAY_READ = 12;
    public static final int ALLOW_GEOMETRY_ARRAY_WRITE = 13;
    public static final int ALLOW_APPEARANCE_READ = 14;
    public static final int ALLOW_APPEARANCE_WRITE = 15;
    public static final int ALLOW_WEIGHTS_READ = 16;
    public static final int ALLOW_WEIGHTS_WRITE = 17;
    public static final int ALLOW_COLLISION_BOUNDS_READ = 18;
    public static final int ALLOW_COLLISION_BOUNDS_WRITE = 19;
    public static final int ALLOW_APPEARANCE_OVERRIDE_READ = 20;
    public static final int ALLOW_APPEARANCE_OVERRIDE_WRITE = 21;

    Morph() {
    }

    public Morph(GeometryArray[] geometryArrayArray) {
        ((MorphRetained)this.retained).setGeometryArrays(geometryArrayArray);
    }

    public Morph(GeometryArray[] geometryArrayArray, Appearance appearance) {
        ((MorphRetained)this.retained).setGeometryArrays(geometryArrayArray);
        ((MorphRetained)this.retained).setAppearance(appearance);
    }

    void createRetained() {
        this.retained = new MorphRetained();
        this.retained.setSource(this);
    }

    public void setCollisionBounds(Bounds bounds) {
        if (this.isLiveOrCompiled() && !this.getCapability(19)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Morph0"));
        }
        ((MorphRetained)this.retained).setCollisionBounds(bounds);
    }

    public Bounds getCollisionBounds() {
        if (this.isLiveOrCompiled() && !this.getCapability(18)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Morph1"));
        }
        return ((MorphRetained)this.retained).getCollisionBounds();
    }

    public void setGeometryArrays(GeometryArray[] geometryArrayArray) {
        if (this.isLiveOrCompiled() && !this.getCapability(13)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Morph2"));
        }
        ((MorphRetained)this.retained).setGeometryArrays(geometryArrayArray);
    }

    public GeometryArray getGeometryArray(int n) {
        if (this.isLiveOrCompiled() && !this.getCapability(12)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Morph3"));
        }
        return ((MorphRetained)this.retained).getGeometryArray(n);
    }

    public void setAppearance(Appearance appearance) {
        if (this.isLiveOrCompiled() && !this.getCapability(15)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Morph4"));
        }
        ((MorphRetained)this.retained).setAppearance(appearance);
    }

    public Appearance getAppearance() {
        if (this.isLiveOrCompiled() && !this.getCapability(14)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Morph5"));
        }
        return ((MorphRetained)this.retained).getAppearance();
    }

    public boolean intersect(SceneGraphPath sceneGraphPath, PickShape pickShape) {
        return this.intersect(sceneGraphPath, pickShape, null);
    }

    public boolean intersect(SceneGraphPath sceneGraphPath, PickRay pickRay, double[] dArray) {
        if (this.isLiveOrCompiled()) {
            this.checkForAllowIntersect();
        }
        return ((MorphRetained)this.retained).intersect(sceneGraphPath, pickRay, dArray);
    }

    public boolean intersect(SceneGraphPath sceneGraphPath, PickShape pickShape, double[] dArray) {
        if (this.isLiveOrCompiled()) {
            this.checkForAllowIntersect();
        }
        if (pickShape instanceof PickPoint) {
            throw new IllegalArgumentException(J3dI18N.getString("Morph10"));
        }
        return ((MorphRetained)this.retained).intersect(sceneGraphPath, pickShape, dArray);
    }

    public void setWeights(double[] dArray) {
        if (this.isLiveOrCompiled() && !this.getCapability(17)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Morph8"));
        }
        ((MorphRetained)this.retained).setWeights(dArray);
    }

    public double[] getWeights() {
        if (this.isLiveOrCompiled() && !this.getCapability(16)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Morph9"));
        }
        return ((MorphRetained)this.retained).getWeights();
    }

    public void setAppearanceOverrideEnable(boolean bl) {
        if (this.isLiveOrCompiled() && !this.getCapability(21)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Morph11"));
        }
        ((MorphRetained)this.retained).setAppearanceOverrideEnable(bl);
    }

    public boolean getAppearanceOverrideEnable() {
        if (this.isLiveOrCompiled() && !this.getCapability(20)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Morph12"));
        }
        return ((MorphRetained)this.retained).getAppearanceOverrideEnable();
    }

    public Node cloneNode(boolean bl) {
        Morph morph = new Morph();
        morph.duplicateNode(this, bl);
        return morph;
    }

    public void duplicateNode(Node node, boolean bl) {
        this.checkDuplicateNode(node, bl);
    }

    void duplicateAttributes(Node node, boolean bl) {
        super.duplicateAttributes(node, bl);
        MorphRetained morphRetained = (MorphRetained)node.retained;
        MorphRetained morphRetained2 = (MorphRetained)this.retained;
        Hashtable hashtable = node.nodeHashtable;
        double[] dArray = morphRetained.getWeights();
        morphRetained2.setCollisionBounds(morphRetained.getCollisionBounds());
        morphRetained2.setAppearance((Appearance)this.getNodeComponent(morphRetained.getAppearance(), bl, hashtable));
        GeometryArray[] geometryArrayArray = new GeometryArray[dArray.length];
        int n = dArray.length - 1;
        while (n >= 0) {
            geometryArrayArray[n] = (GeometryArray)this.getNodeComponent(morphRetained.getGeometryArray(n), bl, hashtable);
            --n;
        }
        morphRetained2.setGeometryArrays(geometryArrayArray);
        morphRetained2.setWeights(dArray);
    }

    private void checkForAllowIntersect() {
        MorphRetained morphRetained = (MorphRetained)this.retained;
        int n = 0;
        while (n < morphRetained.numGeometryArrays) {
            if (!morphRetained.geometryArrays[n].source.getCapability(18)) {
                throw new CapabilityNotSetException(J3dI18N.getString("Morph6"));
            }
            ++n;
        }
    }
}

