/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.guitar.model.wrapper;

import edu.umd.cs.guitar.model.GHashcodeGenerator;
import edu.umd.cs.guitar.model.data.AttributesType;
import edu.umd.cs.guitar.model.data.ComponentType;
import edu.umd.cs.guitar.model.data.ContainerType;
import edu.umd.cs.guitar.model.data.GUIStructure;
import edu.umd.cs.guitar.model.data.GUIType;
import edu.umd.cs.guitar.model.data.ObjectFactory;
import edu.umd.cs.guitar.model.data.PropertyType;
import edu.umd.cs.guitar.model.wrapper.ComponentTypeWrapper;
import edu.umd.cs.guitar.model.wrapper.GUIStructureWrapper;
import edu.umd.cs.guitar.util.GUITARLog;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class GUITypeWrapper {
    GUIType dGUIType;
    String ID;
    ComponentTypeWrapper container;
    ComponentTypeWrapper invoker;
    List<ComponentTypeWrapper> lInvokers;

    public String toString() {
        return "GUITypeWrapper [ID=" + this.ID + "]";
    }

    public List<ComponentTypeWrapper> getInvokerList() {
        if (this.lInvokers == null) {
            this.lInvokers = new ArrayList<ComponentTypeWrapper>();
        }
        return this.lInvokers;
    }

    public void parseData(GUIStructure dGUIStructure, GUIStructureWrapper wGUIStructure) {
        GUITARLog.log.debug((Object)("Parsing window: " + this.getTitle()));
        this.container = new ComponentTypeWrapper(this.dGUIType.getContainer());
        this.container.setWindow(this);
        this.container.parseData(dGUIStructure, wGUIStructure);
    }

    public ComponentTypeWrapper getInvoker() {
        return this.invoker;
    }

    public void setInvoker(ComponentTypeWrapper invoker) {
        this.invoker = invoker;
    }

    public ComponentTypeWrapper getContainer() {
        return this.container;
    }

    public GUITypeWrapper(GUIType data) {
        this.dGUIType = data;
        this.ID = this.getTitle();
    }

    public GUIType getData() {
        return this.dGUIType;
    }

    public ComponentTypeWrapper getChildByID(String ID) {
        ComponentTypeWrapper subContainer = this.container;
        if (subContainer == null) {
            subContainer = new ComponentTypeWrapper(this.dGUIType.getContainer());
        }
        return subContainer.getChildByID(ID);
    }

    public void setValueByName(String sTitle, String sName, String sValue) {
        ComponentType window = this.dGUIType.getWindow();
        ComponentTypeWrapper windowA = new ComponentTypeWrapper(window);
        windowA.setValueByName(sTitle, sName, sValue);
        ContainerType container = this.dGUIType.getContainer();
        ComponentTypeWrapper containerA = new ComponentTypeWrapper(container);
        containerA.setValueByName(sTitle, sName, sValue);
    }

    public void addValueByName(String sTitle, String sName, String sValue) {
        ComponentType window = this.dGUIType.getWindow();
        ComponentTypeWrapper windowA = new ComponentTypeWrapper(window);
        windowA.addValueByName(sTitle, sName, sValue);
        ContainerType container = this.dGUIType.getContainer();
        ComponentTypeWrapper containerA = new ComponentTypeWrapper(container);
        containerA.addValueByName(sTitle, sName, sValue);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof GUITypeWrapper)) {
            return false;
        }
        GUITypeWrapper other = (GUITypeWrapper)obj;
        String sMyTitle = this.getTitle();
        String sOtherTitle = other.getTitle();
        return sMyTitle.equals(sOtherTitle);
    }

    public String getTitle() {
        ComponentType window = this.dGUIType.getWindow();
        ComponentTypeWrapper winAdapter = new ComponentTypeWrapper(window);
        String sGUITitle = winAdapter.getFirstValueByName("Title");
        return sGUITitle;
    }

    public void setTitle(String sTitle) {
        ObjectFactory factory = new ObjectFactory();
        ComponentType window = this.dGUIType.getWindow();
        AttributesType attributes = window.getAttributes();
        PropertyType newProperty = factory.createPropertyType();
        newProperty.setName("Title");
        ArrayList<String> value = new ArrayList<String>();
        value.add(sTitle);
        List<PropertyType> lProperty = attributes.getProperty();
        for (int i = 0; i < lProperty.size(); ++i) {
            PropertyType p = lProperty.get(i);
            if (!p.getName().equals("Title")) continue;
            lProperty.add(i, newProperty);
            lProperty.remove(p);
        }
    }

    public boolean isRoot() {
        ComponentType window = this.dGUIType.getWindow();
        ComponentTypeWrapper windowA = new ComponentTypeWrapper(window);
        String isRoot = windowA.getFirstValueByName("Rootwindow");
        return isRoot.equalsIgnoreCase("true");
    }

    public boolean isModal() {
        ComponentType window = this.dGUIType.getWindow();
        ComponentTypeWrapper windowA = new ComponentTypeWrapper(window);
        String isRoot = windowA.getFirstValueByName("Modal");
        return isRoot.equalsIgnoreCase("true");
    }

    public Set<GUITypeWrapper> getAvailableWindowList() {
        HashSet<GUITypeWrapper> retWins = new HashSet<GUITypeWrapper>();
        GUITypeWrapper availWindow = this;
        while (!availWindow.isModal()) {
            retWins.add(availWindow);
            ComponentTypeWrapper invoker = availWindow.invoker;
            if (invoker == null) break;
            availWindow = invoker.getWindow();
        }
        retWins.add(availWindow);
        return retWins;
    }

    public Set<GUITypeWrapper> getAvailableWindowListNew() {
        Set<GUITypeWrapper> retWins = this.getAvailableWindowHelper(this);
        return retWins;
    }

    private Set<GUITypeWrapper> getAvailableWindowHelper(GUITypeWrapper window) {
        HashSet<GUITypeWrapper> allAvailWindows = new HashSet<GUITypeWrapper>();
        if (window.isModal()) {
            allAvailWindows.add(window);
        } else {
            for (ComponentTypeWrapper invoker : window.getInvokerList()) {
                GUITypeWrapper parentWindow = invoker.getWindow();
                Set<GUITypeWrapper> allParentAvailWindows = this.getAvailableWindowHelper(parentWindow);
                allAvailWindows.addAll(allParentAvailWindows);
            }
            allAvailWindows.add(window);
        }
        return allAvailWindows;
    }

    public void addValueBySignature(AttributesType signature, String name, Set<String> values) {
        ContainerType container = this.dGUIType.getContainer();
        ComponentTypeWrapper containerA = new ComponentTypeWrapper(container);
        containerA.addValueBySignature(signature, name, values);
    }

    public ComponentTypeWrapper getComponentBySignature(AttributesType signature) {
        ComponentTypeWrapper container = new ComponentTypeWrapper(this.dGUIType.getContainer());
        return container.getComponentBySignature(signature);
    }

    public void updateValueBySignature(AttributesType signature, String name, Set<String> values) {
        ContainerType container = this.dGUIType.getContainer();
        ComponentTypeWrapper containerA = new ComponentTypeWrapper(container);
        containerA.updateValueBySignature(signature, name, values);
    }

    public int getMaxID() {
        ContainerType container = this.dGUIType.getContainer();
        ComponentTypeWrapper containerA = new ComponentTypeWrapper(container);
        return containerA.getMaxID();
    }

    public void updateID() {
        ContainerType container = this.dGUIType.getContainer();
        ComponentTypeWrapper containerA = new ComponentTypeWrapper(container);
        containerA.updateID();
    }

    public void generateID(GHashcodeGenerator hashcodeGenerator) {
        ContainerType container = this.dGUIType.getContainer();
        ComponentTypeWrapper containerA = new ComponentTypeWrapper(container);
        containerA.generateID(hashcodeGenerator, this);
    }
}

