/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.InputDeviceScheduler;
import javax.media.j3d.VirtualUniverse;
import javax.media.j3d.WakeupOnElapsedTime;
import javax.media.j3d.WakeupOnElapsedTimeHeap;

class TimerThread
extends Thread {
    private static final int WAIT = 0;
    private static final int NOTIFY = 1;
    private static final int STOP = 2;
    private WakeupOnElapsedTimeHeap heap = new WakeupOnElapsedTimeHeap();
    private WakeupOnElapsedTime inputDeviceSchedCond = new WakeupOnElapsedTime(InputDeviceScheduler.samplingTime);
    private WakeupOnElapsedTime soundSchedCond = new WakeupOnElapsedTime(120000L);
    private boolean running = true;
    private volatile boolean waiting = false;

    TimerThread(ThreadGroup threadGroup) {
        super(threadGroup, "J3D-TimerThread");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void add(WakeupOnElapsedTime wakeupOnElapsedTime) {
        WakeupOnElapsedTimeHeap wakeupOnElapsedTimeHeap = this.heap;
        synchronized (wakeupOnElapsedTimeHeap) {
            this.heap.insert(wakeupOnElapsedTime);
        }
        this.runMonitor(1, 0L);
    }

    void addInputDeviceSchedCond() {
        this.inputDeviceSchedCond.triggeredTime = (long)InputDeviceScheduler.samplingTime + System.currentTimeMillis();
        this.add(this.inputDeviceSchedCond);
    }

    void addSoundSchedCond(long l) {
        this.soundSchedCond.triggeredTime = l;
        this.add(this.soundSchedCond);
    }

    void finish() {
        this.runMonitor(2, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(WakeupOnElapsedTime wakeupOnElapsedTime) {
        WakeupOnElapsedTimeHeap wakeupOnElapsedTimeHeap = this.heap;
        synchronized (wakeupOnElapsedTimeHeap) {
            this.heap.extract(wakeupOnElapsedTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        long l = -1L;
        block3: while (this.running) {
            this.runMonitor(0, l);
            long l2 = System.currentTimeMillis();
            while (true) {
                WakeupOnElapsedTime wakeupOnElapsedTime = null;
                l = -1L;
                WakeupOnElapsedTimeHeap wakeupOnElapsedTimeHeap = this.heap;
                synchronized (wakeupOnElapsedTimeHeap) {
                    if (!this.heap.isEmpty() && (l = this.heap.getMin().triggeredTime - l2) <= 0L) {
                        wakeupOnElapsedTime = this.heap.extractMin();
                    }
                }
                if (wakeupOnElapsedTime == null) continue block3;
                if (wakeupOnElapsedTime == this.inputDeviceSchedCond) {
                    VirtualUniverse.mc.sendRunMessage(4);
                    continue;
                }
                if (wakeupOnElapsedTime == this.soundSchedCond) {
                    VirtualUniverse.mc.sendRunMessage(2);
                    continue;
                }
                wakeupOnElapsedTime.setTriggered();
            }
        }
    }

    synchronized void runMonitor(int n, long l) {
        switch (n) {
            case 0: {
                try {
                    if (this.running) {
                        this.waiting = true;
                        if (l < 0L) {
                            this.wait();
                        } else {
                            this.wait(l);
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.waiting = false;
                break;
            }
            case 1: {
                this.notify();
                break;
            }
            case 2: {
                this.running = false;
                this.notify();
            }
        }
    }
}

