//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.htmlmonitor;

import java.util.ArrayList;
import java.util.List;

/**
 * <p>
 * TODO comment
 * </p>
 * 
 * @author Patrick Harms
 */
class HtmlPageElement {

    /**
     * 
     */
    private String parentPath;
    
    /**
     * 
     */
    private String tagName;
    
    /**
     * 
     */
    private String id;
    
    /**
     * 
     */
    private String title;
    
    /**
     * 
     */
    private Integer index;
    
    /**
     * 
     */
    private List<HtmlPageElement> children;

    /**
     * <p>
     * TODO: comment
     * </p>
     *
     * @param tagName
     * @param index
     * @param id
     * @param children
     */
    HtmlPageElement(String parentPath, String tagName, String id, Integer index) {
        this.parentPath = parentPath;
        this.tagName = tagName;
        this.id = id;
        this.index = index;
    }

    /**
     * <p>
     * TODO: comment
     * </p>
     *
     * @param tagName
     * @param index
     * @param id
     * @param children
     */
    HtmlPageElement(String parentPath, String tagName, String id, String title, Integer index) {
        this(parentPath, tagName, id, index);
        this.title = title;
    }

    /**
     * @return the tagName
     */
    String getTagName() {
        return tagName;
    }

    /**
     * @return the id
     */
    String getId() {
        return id;
    }

    /**
     * @return the title
     */
    String getTitle() {
        return title;
    }

    /**
     * @return the index
     */
    Integer getIndex() {
        return index;
    }

    /**
     * @return the children
     */
    List<HtmlPageElement> getChildren() {
        return children;
    }


    /**
     * 
     */
    void addChild(HtmlPageElement child) {
        if (child != null) {
            if (children == null) {
                children = new ArrayList<HtmlPageElement>();
            }
            
            children.add(child);
        }
    }

    /**
     * <p>
     * TODO: comment
     * </p>
     *
     * @return
     */
    String getParentPath() {
        return parentPath;
    }

    /**
     * <p>
     * TODO: comment
     * </p>
     *
     * @return
     */
    String getPath() {
        StringBuffer result = new StringBuffer();
        if (parentPath != null) {
            result.append(parentPath);
        }

        result.append("/");
        result.append(tagName);
        
        if ((id != null) && (!"".equals(id))) {
            result.append("(id=");
            result.append(id);
            result.append(")");
        }
        else {
            result.append("[");
            result.append(index);
            result.append("]");
        }
        
        return result.toString();
    }

}
