package de.ugoe.cs.eventbench.commands;


import java.security.InvalidParameterException;
import java.util.List;
import java.util.Random;

import de.ugoe.cs.eventbench.data.Event;
import de.ugoe.cs.eventbench.data.GlobalDataContainer;
import de.ugoe.cs.eventbench.models.FirstOrderMarkovModel;
import de.ugoe.cs.eventbench.models.HighOrderMarkovModel;
import de.ugoe.cs.util.console.Command;
import de.ugoe.cs.util.console.Console;

public class CMDtrainMarkovModel implements Command {

	@Override
	public void help() {
		Console.println("Usage: trainMarkovModel <modelName> {<order>}");
	}

	@SuppressWarnings("unchecked")
	@Override
	public void run(List<Object> parameters) {
		String modelname;
		int order = 1;
		try {
			modelname = (String) parameters.get(0);
			if( parameters.size()==2 ) {
				order = Integer.parseInt((String) parameters.get(0));
			}
		} catch (Exception e) {
			throw new InvalidParameterException();
		}
		
		List<List<Event<?>>> sequences = null;
		Object dataObject = GlobalDataContainer.getInstance().getData("sequences");
			
		try {
			sequences = (List<List<Event<?>>>) dataObject;
			if( sequences.size()>0 ) {
				if( sequences.get(0).get(0) instanceof Event ) {
					HighOrderMarkovModel model;
					if( order==1 ) {
						model = new FirstOrderMarkovModel(new Random());
					} else {
						model = new HighOrderMarkovModel(order, new Random());
					}
					model.train(sequences);
					if( GlobalDataContainer.getInstance().addData(modelname, model) ) {
						Console.traceln("Old data \"" + modelname + "\" overwritten");
					}
				} else {
					Console.traceln("Illegal use of \"sequences\" parameter in the GlobalDataContainer.");
					Console.traceln("The parameter should always be of type List<List<Event>>!");
				}
			}
		}
		catch(ClassCastException e) {
			Console.println("Sequences need to be loaded first using parseXML");
		}
	}

}
