package de.ugoe.cs.eventbench.commands;

import java.security.InvalidParameterException;
import java.util.List;

import de.ugoe.cs.eventbench.data.GlobalDataContainer;
import de.ugoe.cs.eventbench.models.IDotCompatible;
import de.ugoe.cs.util.console.Command;
import de.ugoe.cs.util.console.Console;

public class CMDprintDot implements Command {

	@Override
	public void help() {
		Console.println("Usage: printDot <modelname>");
	}

	@Override
	public void run(List<Object> parameters) {
		String modelname = "";
		try {
			modelname = (String) parameters.get(0);
		} catch (Exception e) {
			throw new InvalidParameterException();
		}
		
		IDotCompatible model = null; 
		Object dataObject = GlobalDataContainer.getInstance().getData(modelname);
		if( dataObject==null ) {
			Console.println("Model " + modelname + "not found in storage.");
		}
		else if( !(dataObject instanceof IDotCompatible) ) {
			Console.println("Object " + modelname + " does not implement IDotCompatible!");
		} else {
			model = (IDotCompatible) dataObject;
			Console.println(model.getDotRepresentation());
		}
	}

}
