package de.ugoe.cs.autoquest.usability.evaluation.rule.set;

import static de.ugoe.cs.autoquest.usability.evaluation.rule.set.RulesetFactory.emptyUsabilityRuleset;
import static de.ugoe.cs.autoquest.usability.evaluation.rule.set.RulesetFactory.textInputUsabiliyRuleset;
import static de.ugoe.cs.autoquest.usability.evaluation.rule.set.RulesetFactory.mouseInteractionUsabiliyRuleset;
import static de.ugoe.cs.autoquest.usability.testutil.FestConditionUtil.noUsabilityRules;
import static de.ugoe.cs.autoquest.usability.testutil.FestConditionUtil.usabilityRules;
import static org.fest.assertions.api.Assertions.assertThat;

import org.junit.Test;

public class RulesetFactoryTest {
    
    @Test
    public void empty_ruleset_factory_method_should_return_empty_ruleset() {
	UsabilityRuleset ruleset = emptyUsabilityRuleset();
	assertThat(ruleset).isInstanceOf(EmptyUsabilityRuleset.class).has(noUsabilityRules());
    }
    
    @Test
    public void text_input_ruleset_factory_method_should_return_text_input_ruleset() {
	UsabilityRuleset ruleset = textInputUsabiliyRuleset();
	assertThat(ruleset).isInstanceOf(TextInputUsabiliyRuleset.class).has(usabilityRules());
    }
    
    @Test
    public void mouse_interaction_ruleset_factory_method_should_return_mouse_interaction_ruleset() {
        UsabilityRuleset ruleset = mouseInteractionUsabiliyRuleset();
        assertThat(ruleset).isInstanceOf(MouseInteractionUsabilityRuleset.class).has(usabilityRules());
    }

}
