package de.ugoe.cs.autoquest.usability.sandboxapp;

import static de.ugoe.cs.autoquest.usability.tasktree.filter.EventTypeFilter.MOUSE_BUTTON_INTERACTION;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;

import javax.imageio.ImageIO;

import de.ugoe.cs.autoquest.eventcore.gui.MouseButtonInteraction;
import de.ugoe.cs.autoquest.tasktrees.treeifc.IEventTask;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskTree;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskTreeNode;
import de.ugoe.cs.autoquest.usability.tasktree.filter.FilterStatistic;
import de.ugoe.cs.autoquest.usability.tasktree.filter.IterativeDFSFilterStrategy;
import de.ugoe.cs.autoquest.usability.tasktree.filter.TaskTreeFilter;
import de.ugoe.cs.autoquest.usability.testutil.GenerateTaskTreeUtil;

public class CreateClickstreamImageFromTaskTreeDemoApp {

    private static final String fileToParse = "javatrace.xml";
    
    private static final String clickstreamFilename = "clickstream.png";
    
    /**
     * <p>
     * TODO: comment
     * </p>
     *
     * @param args
     * @throws IOException 
     */
    public static void main(String[] args) throws IOException {
        ITaskTree taskTree = GenerateTaskTreeUtil.getTaskTreeFromFile(fileToParse);
        FilterStatistic mouseInteractions = filterMouseInteractions(taskTree);
        
        BufferedImage clickstreamImage = new BufferedImage(1024, 768, BufferedImage.TYPE_INT_ARGB);
        Graphics2D drawArea = clickstreamImage.createGraphics();
        drawArea.setColor(Color.BLACK);
        drawArea.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        
        drawClickstream(mouseInteractions, drawArea);

        ImageIO.write(clickstreamImage, "png", new File(clickstreamFilename));
    }

    private static void drawClickstream(FilterStatistic mouseInteractions, Graphics2D g2) {
        int xb = -1;
        int yb = -1;
        
        for(ITaskTreeNode node : mouseInteractions.nodesMatchedFilter()) {
            MouseButtonInteraction interaction = (MouseButtonInteraction) ((IEventTask) node).getEventType();
            int x = interaction.getX();
            int y = interaction.getY();
            g2.fillOval(x,y,1,1);
            if(xb != -1 && y != -1) g2.drawLine(x, y, xb, yb);
            xb = x;
            yb = y;
        }
    }
    
    private static FilterStatistic filterMouseInteractions(ITaskTree taskTree) {
        return new TaskTreeFilter(new IterativeDFSFilterStrategy())
            .filterByEventType(MOUSE_BUTTON_INTERACTION).from(taskTree);
    }

}
