package de.ugoe.cs.autoquest.usability.testutil;

import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskTree;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskTreeNode;
import de.ugoe.cs.autoquest.tasktrees.treeimpl.TaskTreeNode;
import de.ugoe.cs.autoquest.tasktrees.treeimpl.TaskTreeNodeFactory;

public class TaskTreeBuilder {
    
    public static CreateRootNodeStep builder() {
        return new CreateRootNodeStep();
    }
    
    public static class CreateRootNodeStep {
        
        public AddChildrenStep root(String name) {
            return new AddChildrenStep(new TaskTreeNode(name));
        }
        
    }
    
    public static class AddChildrenStep {
        
        private TaskTreeNode rootNode;
        
        public AddChildrenStep(TaskTreeNode taskTreeRootNode) {
            this.rootNode = taskTreeRootNode;
        }

        public AddChildrenStep addChild(ITaskTreeNode childNode) {
            this.rootNode.getChildren().add(childNode);
            return this;
        }
        
        public ITaskTree creatTaskTree() {
            return new TaskTreeNodeFactory().createTaskTree(rootNode);
        }
        
    }
    
//        private Employee employee;
//
//        public EmployeeBuilder() {
//            employee = new Employee();
//        }
//
//        public static EmployeeBuilder defaultValues() {
//            return new EmployeeBuilder();
//        }
//
//        public static EmployeeBuilder clone(Employee toClone) {
//            EmployeeBuilder builder = defaultValues();
//            builder.setId(toClone.getId());
//            builder.setName(toClone.getName());
//            builder.setDepartment(toClone.getDepartment());
//            return builder;
//        }
//
//        public static EmployeeBuilder random() {
//            EmployeeBuilder builder = defaultValues();
//            builder.setId(getRandomInteger(0, 1000));
//            builder.setName(getRandomString(20));
//            builder.setDepartment(Department.values()[getRandomInteger(0, Department.values().length - 1)]);
//            return builder;
//        }
//
//        public EmployeeBuilder setId(int id) {
//            employee.setId(id);
//            return this;
//        }
//
//        public EmployeeBuilder setName(String name) {
//            employee.setName(name);
//            return this;
//        }
//
//        public EmployeeBuilder setDepartment(Department dept) {
//            employee.setDepartment(dept);
//            return this;
//        }
//
//        public Employee build() {
//            return employee;
//        }
//    }

}
