package de.ugoe.cs.autoquest.usability;

import java.util.EnumSet;
import java.util.List;

import lombok.AccessLevel;
import lombok.NoArgsConstructor;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;

import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskTree;
import de.ugoe.cs.autoquest.usability.evaluation.result.UsabilityDefect;
import de.ugoe.cs.autoquest.usability.evaluation.rule.set.UsabilityRule;
import de.ugoe.cs.autoquest.usability.evaluation.rule.set.UsabilityRuleset;

@NoArgsConstructor(access = AccessLevel.PRIVATE)
public class UsabilityEvaluationFacade {

    public static ExecuteUsabilityEvaluationStep applyUsabilityRuleset(UsabilityRuleset usabilityRuleset) {
	Preconditions.checkNotNull(usabilityRuleset);
        return new ExecuteUsabilityEvaluationStep(usabilityRuleset);
    }

    protected static class ExecuteUsabilityEvaluationStep {
	
	private UsabilityRuleset usabilityRuleset;

	public ExecuteUsabilityEvaluationStep(UsabilityRuleset usabilityRuleset) {
	    this.usabilityRuleset = usabilityRuleset;
	}

	public UsabilityEvaluationReport evaluateUsabilityOf(ITaskTree taskTree) {
	    Preconditions.checkNotNull(taskTree);
	    EnumSet<? extends UsabilityRule> rulesetForUsabilityEvaluation = usabilityRuleset.getRulesetForUsabilityEvaluation();
	    List<UsabilityDefect> evaluationResults = 
		    Lists.newArrayListWithCapacity(rulesetForUsabilityEvaluation.size());
	    for(UsabilityRule usabilityRule : rulesetForUsabilityEvaluation) {
		Optional<UsabilityDefect> ruleEvaluationResult = usabilityRule.evaluate(taskTree);
		if(ruleEvaluationResult.isPresent()) {
		    evaluationResults.add(ruleEvaluationResult.get());
		}
	    }
	    return UsabilityEvaluationReport.from(evaluationResults);
	}
	
    }

}
