
package de.ugoe.cs.autoquest.usability.evaluation.result;

import java.util.Map;

import lombok.Getter;
import de.ugoe.cs.autoquest.usability.DefectDescription;
import de.ugoe.cs.autoquest.usability.ParameterFragment;

public class UsabilityDefect {

    @Getter
    private UsabilityDefectSeverityLevel severityLevel;

    private DefectDescription defectDescription;

    private Map<String, String> descriptionParametersValues;

    public UsabilityDefect(UsabilityDefectSeverityLevel severityLevel,
                                           DefectDescription recommendationDescription,
                                           Map<String, String> descriptionParametersValues) {
        this.severityLevel = severityLevel;
        this.defectDescription = recommendationDescription;
        this.descriptionParametersValues = descriptionParametersValues;
    }

    public String defectDescription() {
        StringBuffer result = new StringBuffer();

        for (Object fragment : defectDescription.getTextFragmentOrParameterFragment()) {
            if (result.length() > 0) {
                result.append(" ");
            }

            if (fragment instanceof ParameterFragment) {
                String value = null;
                if (descriptionParametersValues != null) {
                    value =
                        descriptionParametersValues.get(((ParameterFragment) fragment)
                            .getParameterName());
                }

                if (value != null) {
                    result.append(value);
                }
                else {
                    throw new IllegalArgumentException("required parameter \"" +
                        ((ParameterFragment) fragment).getParameterName() +
                        "\" for usability defect description not provided");
                }
            }
            else {
                result.append(getFragmentString(fragment));
            }
        }

        return result.toString();
    }

    private String getFragmentString(Object fragment) {
        String fragmentStr = fragment.toString().trim();

        fragmentStr = fragmentStr.replaceAll("\n", " ");

        while (fragmentStr.indexOf("  ") > -1) {
            fragmentStr = fragmentStr.replaceAll("  ", " ");
        }

        return fragmentStr;
    }

}
