package de.ugoe.cs.autoquest.usability.evaluation.result;

import java.io.IOException;
import java.io.InputStream;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Unmarshaller;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;

import de.ugoe.cs.autoquest.usability.DefectDescription;
import de.ugoe.cs.autoquest.usability.DefectDescriptions;
import de.ugoe.cs.autoquest.usability.evaluation.rule.set.UsabilityRule;

public class UsabilityDefectXmlDescriptionResolver implements UsabilityDefectDescriptionResolver {
    
    private static final String DEFAULT_MESSAGES_FILE = "defectDescriptions_en.xml";
    
    private static final UsabilityDefectXmlDescriptionResolver instance = new UsabilityDefectXmlDescriptionResolver();
    
    private DefectDescriptions defectDescriptions;
    
    private UsabilityDefectXmlDescriptionResolver() {
        loadDescriptions();
    }
    
    @SuppressWarnings("unchecked")
    private void loadDescriptions() {
        InputStream inputStream =
                ClassLoader.getSystemResourceAsStream(DEFAULT_MESSAGES_FILE);
        try {
            String packageName = DefectDescriptions.class.getPackage().getName();
            JAXBContext jaxbContext = JAXBContext.newInstance(packageName);
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();

            defectDescriptions =
                ((JAXBElement<DefectDescriptions>) unmarshaller.unmarshal(inputStream))
                    .getValue();
        }
        catch (Exception e) {
            throw new RuntimeException
                ("error while initializing usability defect descriptions", e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    // ignore
                }
            }
        }
    }
    
    public static UsabilityDefectXmlDescriptionResolver instance() {
        return instance;
    }

    @Override
    public DefectDescription descriptionFor(final UsabilityRule usabilityRule) {
        Optional<DefectDescription> guidlineDescription = Iterables.tryFind(defectDescriptions.getDefectDescription(), new Predicate<DefectDescription>() {
            
            public boolean apply(DefectDescription defectDescription) {
                return usabilityRule.ruleIdentifier().equals(defectDescription.getDefectId());
            }
            
        });
        if(!guidlineDescription.isPresent())
            throw new RuntimeException
            ("error while initializing usability defect descriptions. No " +
                    "description text available for description " + usabilityRule.ruleIdentifier());
        return guidlineDescription.get();
    }

}
