package de.ugoe.cs.autoquest.usability.evaluation.rule.set;

import java.util.EnumSet;

import org.apache.commons.lang.StringUtils;

import com.google.common.base.Optional;

import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskTree;
import de.ugoe.cs.autoquest.usability.evaluation.result.UsabilityDefect;

public class EmptyUsabilityRuleset implements UsabilityRuleset {
    
    private enum EmptyUsabilityRule implements UsabilityRule {
	;

        @Override
        public Optional<UsabilityDefect> evaluate(ITaskTree taskTree) {
            return Optional.absent();
        }

        @Override
        public String ruleIdentifier() {
            return StringUtils.EMPTY;
        }

    }
    
    private final EnumSet<EmptyUsabilityRule> EMPTY_USABILITY_RULESET = 
	    EnumSet.noneOf(EmptyUsabilityRule.class);

    @Override
    public EnumSet<? extends UsabilityRule> getRulesetForUsabilityEvaluation() {
	return EMPTY_USABILITY_RULESET;
    }

}
