
package de.ugoe.cs.autoquest.usability.evaluation.rule.set;

import java.util.EnumSet;

import com.google.common.base.Optional;

import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskTree;
import de.ugoe.cs.autoquest.usability.evaluation.result.UsabilityDefect;
import de.ugoe.cs.autoquest.usability.evaluation.rule.evaluator.NoLetterOrDigitTextInputsEvaluator;
import de.ugoe.cs.autoquest.usability.evaluation.rule.evaluator.TextInputEntryRepetitionsEvaluator;
import de.ugoe.cs.autoquest.usability.evaluation.rule.evaluator.TextInputRatioEvaluator;

public class TextInputUsabiliyRuleset implements UsabilityRuleset {

    private enum TextInputUsabilityRule implements UsabilityRule {

        TEXT_FIELD_INPUT_RATIO {
            
            @Override
            public Optional<UsabilityDefect> evaluate(ITaskTree taskTree) {
                return new TextInputRatioEvaluator(this, taskTree).evaluationResult();
            }

            @Override
            public String ruleIdentifier() {
                return this.name();
            }

        },

        TEXT_FIELD_INPUT_REPETITIONS {

            @Override
            public Optional<UsabilityDefect> evaluate(ITaskTree taskTree) {
                return new TextInputEntryRepetitionsEvaluator(this, taskTree).evaluationResult();
            }

            @Override
            public String ruleIdentifier() {
                return this.name();
            }

        },

        TEXT_FIELD_NO_LETTER_OR_DIGIT_RATIO {

            @Override
            public Optional<UsabilityDefect> evaluate(ITaskTree taskTree) {
                return new NoLetterOrDigitTextInputsEvaluator(this, taskTree).evaluationResult();
            }

            @Override
            public String ruleIdentifier() {
                return this.name();
            }


        };
        
        public abstract Optional<UsabilityDefect> evaluate(ITaskTree taskTree);

    }

    private final EnumSet<TextInputUsabilityRule> TEXT_INPUT_USABILITY_RULESET = EnumSet
        .allOf(TextInputUsabilityRule.class);

    @Override
    public EnumSet<? extends UsabilityRule> getRulesetForUsabilityEvaluation() {
        return TEXT_INPUT_USABILITY_RULESET;
    }

}
