package de.ugoe.cs.autoquest.usability.tasktree.filter;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;

import de.ugoe.cs.autoquest.eventcore.IEventTarget;
import de.ugoe.cs.autoquest.eventcore.guimodel.ITextArea;
import de.ugoe.cs.autoquest.eventcore.guimodel.ITextField;
import de.ugoe.cs.autoquest.tasktrees.treeifc.IEventTask;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskTreeNode;

public enum EventTargetFilter implements TaskTreeNodeFilter<IEventTarget> {

    TEXT_FIELD(ITextField.class),
    
    TEXT_AREA(ITextArea.class);
    
    private Class<? extends IEventTarget> eventTargetClazz;
    
    private EventTargetFilter(Class<? extends IEventTarget> eventTargetClazz) {
        this.eventTargetClazz = eventTargetClazz;
    }

    @SuppressWarnings("unchecked")
    @Override
    public Class<IEventTarget> clazz() {
        return (Class<IEventTarget>) eventTargetClazz;
    }

    @SuppressWarnings("rawtypes")
    @Override
    public Predicate filterPredicate() {
        Predicate<Object> instanceOfIEventTaskPredicate = Predicates.instanceOf(IEventTask.class);
        Predicate<ITaskTreeNode> nodeHoldsInstanceOfFilterArgument =
            Predicates.compose(Predicates.instanceOf(eventTargetClazz), nodeExtractionFunction());
        return Predicates.and(instanceOfIEventTaskPredicate, nodeHoldsInstanceOfFilterArgument);
    }
    
    private Function<ITaskTreeNode, IEventTarget> nodeExtractionFunction() {
        return new Function<ITaskTreeNode, IEventTarget>() {
            
            @Override
            public IEventTarget apply(ITaskTreeNode treeNode) {
                return ((IEventTask) treeNode).getEventTarget();
            }
        };
    }
    
}
