package de.ugoe.cs.autoquest.usability.tasktree.filter;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;

import de.ugoe.cs.autoquest.eventcore.IEventType;
import de.ugoe.cs.autoquest.eventcore.gui.MouseButtonInteraction;
import de.ugoe.cs.autoquest.eventcore.gui.MouseInteraction;
import de.ugoe.cs.autoquest.eventcore.gui.TextInput;
import de.ugoe.cs.autoquest.tasktrees.treeifc.IEventTask;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskTreeNode;

public enum EventTypeFilter implements TaskTreeNodeFilter<IEventType> {
    
    TEXT_INPUT(TextInput.class),
    
    MOUSE_INTERACTION(MouseInteraction.class),
    
    MOUSE_BUTTON_INTERACTION(MouseButtonInteraction.class);
    
    private Class<? extends IEventType> eventTypeClazz;
    
    private EventTypeFilter(Class<? extends IEventType> eventTypeClazz) {
        this.eventTypeClazz = eventTypeClazz;
    }

    @SuppressWarnings("unchecked")
    @Override
    public Class<IEventType> clazz() {
        return (Class<IEventType>) eventTypeClazz;
    }
    
    @SuppressWarnings("rawtypes")
    @Override
    public Predicate filterPredicate() {
        Predicate<Object> instanceOfIEventTaskPredicate = Predicates.instanceOf(IEventTask.class);
        Predicate<ITaskTreeNode> nodeHoldsInstanceOfFilterArgument =
            Predicates.compose(Predicates.instanceOf(eventTypeClazz), nodeExtractionFunction());
        return Predicates.and(instanceOfIEventTaskPredicate, nodeHoldsInstanceOfFilterArgument);
    }
    
    private Function<ITaskTreeNode, IEventType> nodeExtractionFunction() {
        return new Function<ITaskTreeNode, IEventType>() {
            
            @Override
            public IEventType apply(ITaskTreeNode treeNode) {
                return ((IEventTask) treeNode).getEventType();
            }
        };
    }
    }
