//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.plugin.html.guimodel;

import java.net.URL;

import de.ugoe.cs.autoquest.eventcore.guimodel.IGUIElementSpec;

/**
 * <p>
 * TODO comment
 * </p>
 * 
 * @author Patrick Harms
 */
public class HTMLPageSpec extends HTMLGUIElementSpec implements IGUIElementSpec {

    /**  */
    private static final long serialVersionUID = 1L;
    
    /** */
    private HTMLServerSpec server;
    
    /** */
    private String pagePath;
    
    /** */
    private String pageTitle;
    
    /**
     * <p>
     * TODO: comment
     * </p>
     *
     * @param server
     * @param pagePath
     * @param pageTitle
     */
    public HTMLPageSpec(HTMLServerSpec server, String pagePath, String pageTitle) {
        super("page");
        
        if (server == null) {
            throw new IllegalArgumentException("server must not be null");
        }
        else if (pagePath == null) {
            throw new IllegalArgumentException("pagePath must not be null");
        }
        else if (pageTitle == null) {
            throw new IllegalArgumentException("pageTitle must not be null");
        }
        
        this.server = server;
        this.pagePath = pagePath;
        this.pageTitle = pageTitle;
    }

    /**
     * <p>
     * TODO: comment
     * </p>
     *
     * @param server
     * @param pagePath
     * @param pageTitle
     */
    public HTMLPageSpec(URL pageURL, String pageTitle) {
        super("page");
        
        if (pageURL == null) {
            throw new IllegalArgumentException("pageURL must not be null");
        }
        else if (pageTitle == null) {
            throw new IllegalArgumentException("pageTitle must not be null");
        }
        
        this.server = new HTMLServerSpec(pageURL);
        this.pagePath = pageURL.getPath();
        this.pageTitle = pageTitle;
    }

    /* (non-Javadoc)
     * @see de.ugoe.cs.autoquest.eventcore.guimodel.IGUIElementSpec#getSimilarity(IGUIElementSpec)
     */
    @Override
    public boolean getSimilarity(IGUIElementSpec other) {
        if (other instanceof HTMLPageSpec) {
            HTMLPageSpec otherSpec = (HTMLPageSpec) other;
            
            if (!super.getSimilarity(otherSpec)) {
                return false;
            }
            else if (!server.getSimilarity(otherSpec.server)) {
                return false;
            }
            else if (!pagePath.equals(otherSpec.pagePath)) {
                return false;
            }
            else {
                return pageTitle.equals(otherSpec.pageTitle);
            }
        }
        
        return false;
    }

    /**
     * <p>
     * TODO: comment
     * </p>
     *
     * @return
     */
    public HTMLServerSpec getServer() {
        return server;
    }

    /**
     * <p>
     * TODO: comment
     * </p>
     *
     * @return
     */
    String getPagePath() {
        return pagePath;
    }

    /**
     * <p>
     * TODO: comment
     * </p>
     *
     * @return
     */
    String getPageTitle() {
        return pageTitle;
    }

}
