package de.ugoe.cs.autoquest.usability;

import static de.ugoe.cs.autoquest.usability.evaluation.rule.set.RulesetFactory.emptyUsabilityRuleset;
import static org.fest.assertions.api.Assertions.assertThat;

import org.junit.Test;

import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskTree;
import de.ugoe.cs.autoquest.usability.UsabilityEvaluationFacade.ExecuteUsabilityEvaluationStep;
import de.ugoe.cs.autoquest.usability.testutil.DummyUsabilityRuleset;
import de.ugoe.cs.autoquest.usability.testutil.TaskTreeBuilder;

public class UsabilityEvaluationFacadeTest {

    @Test(expected = NullPointerException.class)
    public void apply_null_for_ruleset_should_throw_exception() {
        UsabilityEvaluationFacade.applyUsabilityRuleset(null);
    }
    
    @Test
    public void apply_empty_ruleset_should_return_execute_usability_evaluation_step() {
	ExecuteUsabilityEvaluationStep executeUsabilityEvaluationStep = 
		UsabilityEvaluationFacade.applyUsabilityRuleset(emptyUsabilityRuleset());
	assertThat(executeUsabilityEvaluationStep).isInstanceOf(ExecuteUsabilityEvaluationStep.class);
    }
    
    @Test(expected = NullPointerException.class)
    public void evaluate_usability_of_null_should_throw_exception() {
	UsabilityEvaluationFacade.applyUsabilityRuleset(emptyUsabilityRuleset()).evaluateUsabilityOf(null);
    }
    
    @Test
    public void evaluate_usability_of_task_tree_against_empty_ruleset_should_return_empty_evaluation_report() {
	ITaskTree taskTree =  TaskTreeBuilder.builder().root("Ich bin eine Wurzel").creatTaskTree();
	UsabilityEvaluationReport evaluationReport = 
		UsabilityEvaluationFacade.applyUsabilityRuleset(emptyUsabilityRuleset()).evaluateUsabilityOf(taskTree);
	assertThat(evaluationReport).isNotNull();
    }
    
    @Test
    public void evaluate_usability_of_task_tree_against_dummy_ruleset_should_return_non_empty_evaluation_report() {
        ITaskTree taskTree =  TaskTreeBuilder.builder().root("Ich bin eine Wurzel").creatTaskTree();
        UsabilityEvaluationReport evaluationReport = 
                UsabilityEvaluationFacade.applyUsabilityRuleset(new DummyUsabilityRuleset()).evaluateUsabilityOf(taskTree);
        assertThat(evaluationReport).isNotNull();
    }

}
