package de.ugoe.cs.autoquest.usability;

import java.util.List;

import lombok.AccessLevel;
import lombok.AllArgsConstructor;

import com.google.common.base.Preconditions;

import de.ugoe.cs.autoquest.usability.evaluation.result.UsabilityDefect;

@AllArgsConstructor(access = AccessLevel.PRIVATE)
public class UsabilityEvaluationReport {
    
    private List<UsabilityDefect> evaluationResults;
    
    public static UsabilityEvaluationReport from(List<UsabilityDefect> evaluationResults) {
	Preconditions.checkNotNull(evaluationResults);
	return new UsabilityEvaluationReport(evaluationResults);
    }
    
    public List<UsabilityDefect> evaluationResults() {
        return this.evaluationResults;
    }
    
}
