package de.ugoe.cs.autoquest.usability.tasktree.filter;

import java.util.List;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;

import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskTreeNode;

public class FilterStatistic {
    
    @SuppressWarnings("rawtypes")
    private final Predicate filterPredicate;

    private List<ITaskTreeNode> filteredNodes = Lists.newArrayList();
    
    private List<ITaskTreeNode> nodesNotMatchedFilter = Lists.newArrayList();
    
    @SuppressWarnings("rawtypes")
    public FilterStatistic(Predicate filterPredicate) {
        this.filterPredicate = filterPredicate;
    }
    
    @SuppressWarnings("unchecked")
    public void addNode(ITaskTreeNode node) {
        if (filterPredicate.apply(node)) {
            filteredNodes.add(node);
        } else {
            nodesNotMatchedFilter.add(node);
        }
    }
    
    public List<ITaskTreeNode> nodesMatchedFilter() {
        return this.filteredNodes;
    }
    
    public int nrOfNodesMatchedFilter() {
        return this.filteredNodes.size();
    }
    
    public List<ITaskTreeNode> nodesNotMatchedFilter() {
        return this.nodesNotMatchedFilter;
    }
    
    public int nrOfNodesNotMatchedFilter() {
        return this.nodesNotMatchedFilter.size();
    }
    
}
