
package de.ugoe.cs.autoquest.usability.testutil;

import java.util.logging.Level;

import de.ugoe.cs.autoquest.commands.sequences.CMDcondenseGuiModel;
import de.ugoe.cs.autoquest.commands.sequences.CMDcondenseMouseClicks;
import de.ugoe.cs.autoquest.commands.sequences.CMDcorrectKeyInteractionTargets;
import de.ugoe.cs.autoquest.commands.sequences.CMDdetectTextInputEvents;
import de.ugoe.cs.autoquest.commands.sequences.CMDsortKeyInteractions;
import de.ugoe.cs.autoquest.commands.usability.CMDgenerateTaskTree;
import de.ugoe.cs.autoquest.plugin.jfc.commands.CMDparseJFC;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskTree;
import de.ugoe.cs.autoquest.test.CommandRunner;
import de.ugoe.cs.util.console.Console;
import de.ugoe.cs.util.console.GlobalDataContainer;
import de.ugoe.cs.util.console.TextConsole;

public class GenerateTaskTreeUtil {
    
    private static final String seqName = "sequences";

    private static final String taskTreeName = "taskTree";

    public static ITaskTree getTaskTreeFromFile(String filename) {
        new TextConsole(Level.FINEST);
        parseTraceFile(filename);
        condenseGuiModel();
        sortKeyInteractions();
        correctKeyInteractionTargets();
        detectTextInputEvents();
        condenseMouseClicks();
        return generateTaskTree();
    }

    static private void parseTraceFile(String filetoparse) {
        Console.println("parsing trace file");
        CommandRunner.runCommand(CMDparseJFC.class, ClassLoader.getSystemResource(filetoparse)
            .getFile(), seqName);
    }

    private static void condenseGuiModel() {
        Console.println("condensing GUI model");
        CommandRunner.runCommand(CMDcondenseGuiModel.class, seqName);
    }

    private static void sortKeyInteractions() {
        Console.println("sorting key interactions");
        CommandRunner.runCommand(CMDsortKeyInteractions.class, seqName);
    }

    private static void correctKeyInteractionTargets() {
        Console.println("correcting key interaction targets");
        CommandRunner.runCommand(CMDcorrectKeyInteractionTargets.class, seqName);
    }

    private static void detectTextInputEvents() {
        Console.println("detecting text input events");
        CommandRunner.runCommand(CMDdetectTextInputEvents.class, seqName);
    }

    private static void condenseMouseClicks() {
        Console.println("condensing mouse click events");
        CommandRunner.runCommand(CMDcondenseMouseClicks.class, seqName);
    }

    private static ITaskTree generateTaskTree() {
        CommandRunner.runCommand(CMDgenerateTaskTree.class, seqName, taskTreeName);
        GlobalDataContainer dataContainer = GlobalDataContainer.getInstance();
        return (ITaskTree) dataContainer.getData(taskTreeName);
    }

}
