
package de.ugoe.cs.autoquest.usability.evaluation.result;

import java.util.Map;

import de.ugoe.cs.autoquest.usability.DefectDescription;
import de.ugoe.cs.autoquest.usability.evaluation.rule.set.UsabilityRule;
import lombok.AllArgsConstructor;

@AllArgsConstructor
public class UsabilityDefectFactory {

    private final UsabilityDefectDescriptionResolver usabilityDefectDescriptionResolver;

    public UsabilityDefect createUsabilityGuidlineRecommendation(UsabilityDefectSeverityLevel recommendationSeverityLevel,
                                                                 UsabilityRule usabilityRule,
                                                                 Map<String, String> recommendationMessageParameteValues) {
        DefectDescription guidlineDescription =
            usabilityDefectDescriptionResolver.descriptionFor(usabilityRule);
        return new UsabilityDefect(recommendationSeverityLevel, guidlineDescription,
                                   recommendationMessageParameteValues);

    }

}
