package de.ugoe.cs.autoquest.usability.tasktree.filter;

import java.util.concurrent.TimeUnit;

import com.google.common.base.Optional;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;

public class FilterStatisticCache {

    private static final FilterStatisticCache instance = new FilterStatisticCache();
    
    @SuppressWarnings("rawtypes")
    private Cache<TaskTreeNodeFilter, FilterStatistic> cache;
    
    private FilterStatisticCache() {
        this.cache = CacheBuilder.newBuilder().expireAfterWrite(10, TimeUnit.MINUTES).build();
    }
    
    public static FilterStatisticCache instance() {
        return instance;
    }
    
    @SuppressWarnings("rawtypes")
    public void addFilterStatistic(TaskTreeNodeFilter nodeFilter, FilterStatistic filterStatistic) {
        this.cache.put(nodeFilter, filterStatistic);
    }
    
    @SuppressWarnings("rawtypes")
    public Optional<FilterStatistic> getFilterStatistic(TaskTreeNodeFilter nodeFilter) {
        return Optional.fromNullable(this.cache.getIfPresent(nodeFilter));
    }
    
    public void clear() {
        this.cache.invalidateAll();
    }
    
}
