
package de.ugoe.cs.autoquest.usability.tasktree.filter;

import com.google.common.base.Preconditions;

import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskTree;

public class TaskTreeFilter {
    
    private final TaskTreeFilterStrategy taskTreeFilterStrategy;
    
    public TaskTreeFilter(TaskTreeFilterStrategy treeTraversalStrategy) {
        Preconditions.checkNotNull(treeTraversalStrategy);
        this.taskTreeFilterStrategy = treeTraversalStrategy;
    }

    public FilterEventTargetStep filterByEventTarget(EventTargetFilter eventTarget) {
        return new FilterEventTargetStep(eventTarget);
    }

    public FilterEventTypeStep filterByEventType(EventTypeFilter eventType) {
        return new FilterEventTypeStep(eventType);
    }

    public class FilterEventTargetStep {

        private final EventTargetFilter eventTarget;

        public FilterEventTargetStep(EventTargetFilter eventTarget) {
            this.eventTarget = eventTarget;
        }

        public FilterStatistic from(ITaskTree taskTree) {
            return taskTreeFilterStrategy.filter(taskTree, eventTarget);
        }

    }

    public class FilterEventTypeStep {

        private final EventTypeFilter eventType;

        public FilterEventTypeStep(EventTypeFilter eventType) {
            this.eventType = eventType;
        }

        public FilterStatistic from(ITaskTree taskTree) {
            return taskTreeFilterStrategy.filter(taskTree, eventType);
        }

    }
}
