package de.ugoe.cs.autoquest.usability.util;

import java.util.List;

import com.google.common.base.CharMatcher;
import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multiset;

import de.ugoe.cs.autoquest.eventcore.gui.TextInput;
import de.ugoe.cs.autoquest.tasktrees.treeifc.IEventTask;
import de.ugoe.cs.autoquest.tasktrees.treeifc.ITaskTreeNode;

public class TextInputUtil {
    
    public static Multiset<String> aggregateEnteredTextFromTextInputs(List<ITaskTreeNode> nodesWithTextInputEvents) {
        List<Iterable<String>> allTextInputs = Lists.newArrayList();
        for(ITaskTreeNode nodeWithTextInput : nodesWithTextInputEvents) {
            TextInput textInput = (TextInput) ((IEventTask) nodeWithTextInput).getEventType();
            allTextInputs.add(splitTextIntoWordsAndSigns(textInput.getEnteredText()));
        }
        return HashMultiset.create(Iterables.concat(allTextInputs));
    }
    
    public static Iterable<String> splitTextIntoWordsAndSigns(String enteredText) {
        CharMatcher onlyWords = CharMatcher.WHITESPACE.or(CharMatcher.forPredicate(characterIsJavaIdentifierPartPredicate()));
        CharMatcher onlySigns = CharMatcher.WHITESPACE.or(CharMatcher.forPredicate(characterIsJavaIdentifierPartPredicate()).negate());
        Iterable<String> words = Splitter.on(onlyWords).omitEmptyStrings().trimResults().split(enteredText);
        Iterable<String> signs = Splitter.on(onlySigns).omitEmptyStrings().trimResults().split(enteredText);
        return Iterables.concat(words, signs);
    }
    
    public static Predicate<Character> characterIsJavaIdentifierPartPredicate() {
        return new Predicate<Character>() {
            
            @Override
            public boolean apply(Character character) {
               return  !Character.isJavaIdentifierPart(character);
            }
            
        };
    }
    
    public static Predicate<Character> characterIsLetterOrDigitPredicate() {
        return new Predicate<Character>() {
            
            @Override
            public boolean apply(Character character) {
                return !Character.isLetterOrDigit(character);
            }
            
        };
    }

}
