//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.usability;

import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertNotSame;

import java.util.HashMap;
import java.util.Map;

import org.junit.Test;

import de.ugoe.cs.autoquest.usability.UsabilityDefectDescription;

/**
 * TODO comment
 * 
 * @version $Revision: $ $Date: 20.07.2012$
 * @author 2012, last modified by $Author: pharms$
 */
public class UsabilityDefectDescriptionTest {

    /**
     * TODO: comment
     * 
     */
    @Test
    public void testInitialization() {
        for (UsabilityDefectDescription description : UsabilityDefectDescription.values()) {
            assertNotNull(description.toString());
            assertNotSame("", description.toString());
            System.err.println(description);
        }
    }

    /**
     * TODO: comment
     * 
     */
    @Test
    public void testParameterization() {
        for (UsabilityDefectDescription description : UsabilityDefectDescription.values()) {
            Map<String, String> parameters = new HashMap<String, String>();

            for (String parameter : description.getDescriptionParameters()) {
                parameters.put(parameter, "<parameter " + parameter + ">");
            }

            assertNotNull(description.toString(parameters));
            assertNotSame("", description.toString(parameters));
            System.err.println(description.toString(parameters));
        }
    }

}
