
package de.ugoe.cs.autoquest.usability;

import static de.ugoe.cs.autoquest.usability.testutil.FestConditionUtil.noUsabilityGuidlineRecommendations;
import static de.ugoe.cs.autoquest.usability.testutil.FestConditionUtil.usabilityGuidlineRecommendations;
import static org.fest.assertions.api.Assertions.assertThat;

import java.util.Collections;
import java.util.List;

import org.fest.util.Lists;
import org.junit.Test;

import de.ugoe.cs.autoquest.usability.evaluation.result.UsabilityDefectSeverityLevel;
import de.ugoe.cs.autoquest.usability.evaluation.result.UsabilityDefect;
import de.ugoe.cs.autoquest.usability.evaluation.result.UsabilityDefectFactory;
import de.ugoe.cs.autoquest.usability.testutil.DummyUsabilityGuidlineDescriptionResolver;
import de.ugoe.cs.autoquest.usability.testutil.DummyUsabilityRuleset;

public class UsabilityEvaluationReportTest {

    @Test(expected = NullPointerException.class)
    public void usability_report_from_null_should_throw_exception() {
        UsabilityEvaluationReport.from(null);
    }

    @Test
    public void usability_report_from_empty_list_has_no_recommendations() {
        UsabilityEvaluationReport evaluationReport =
            UsabilityEvaluationReport.from(Collections
                .<UsabilityDefect> emptyList());
        assertThat(evaluationReport).isNotNull().has(noUsabilityGuidlineRecommendations());
    }

    @Test
    public void usability_report_from_non_empty_list_has_recommendations() {
        List<UsabilityDefect> guidlineRecommendations =
            Lists.newArrayList(new UsabilityDefectFactory(new DummyUsabilityGuidlineDescriptionResolver())
                    .createUsabilityGuidlineRecommendation(UsabilityDefectSeverityLevel.INFO,
                                                           new DummyUsabilityRuleset()
                                                               .evaluationRules()
                                                               .iterator().next(),
                                                           Collections.<String, String> emptyMap()));
        UsabilityEvaluationReport evaluationReport =
            UsabilityEvaluationReport.from(guidlineRecommendations);
        assertThat(evaluationReport).isNotNull().has(usabilityGuidlineRecommendations());
    }

}
