package de.ugoe.cs.autoquest.usability.testutil;

import org.fest.assertions.core.Condition;

import com.google.common.base.Optional;

import de.ugoe.cs.autoquest.usability.UsabilityEvaluationReport;
import de.ugoe.cs.autoquest.usability.evaluation.result.UsabilityDefectSeverityLevel;
import de.ugoe.cs.autoquest.usability.evaluation.result.UsabilityDefect;
import de.ugoe.cs.autoquest.usability.evaluation.rule.set.UsabilityRuleset;

public class FestConditionUtil {

    private FestConditionUtil() {
        // no good idea
    }
    
    public static Condition<UsabilityEvaluationReport> noUsabilityGuidlineRecommendations() {
        return new Condition<UsabilityEvaluationReport>() {
    
            @Override
            public boolean matches(UsabilityEvaluationReport usabilityEvaluationReport) {
                return usabilityEvaluationReport.evaluationResults().isEmpty();
            }
        };
    }
    
    public static Condition<UsabilityEvaluationReport> usabilityGuidlineRecommendations() {
        return new Condition<UsabilityEvaluationReport>() {
    
            @Override
            public boolean matches(UsabilityEvaluationReport usabilityEvaluationReport) {
                return !usabilityEvaluationReport.evaluationResults().isEmpty();
            }
        };
    }
    
    public static Condition<UsabilityRuleset> noUsabilityRules() {
        return new Condition<UsabilityRuleset>() {

            @Override
            public boolean matches(UsabilityRuleset usabilityRuleset) {
                return usabilityRuleset.evaluationRules().isEmpty();
            }
    

        };
    }
    
    public static Condition<UsabilityRuleset> usabilityRules() {
        return new Condition<UsabilityRuleset>() {

            @Override
            public boolean matches(UsabilityRuleset usabilityRuleset) {
                return !usabilityRuleset.evaluationRules().isEmpty();
            }
    

        };
    }
    
    public static Condition<Optional<UsabilityDefect>> present() {
        return new Condition<Optional<UsabilityDefect>>() {

            @Override
            public boolean matches(Optional<UsabilityDefect> usabilityGuidlineRecommendation) {
                return usabilityGuidlineRecommendation.isPresent();
            }
    
        };
    }
    
    public static Condition<Optional<UsabilityDefect>> absent() {
        return new Condition<Optional<UsabilityDefect>>() {

            @Override
            public boolean matches(Optional<UsabilityDefect> usabilityGuidlineRecommendation) {
                return !usabilityGuidlineRecommendation.isPresent();
            }
    
        };
    }
    
    public static Condition<Optional<UsabilityDefect>> infoRecommendationSeverityLevel() {
        return new Condition<Optional<UsabilityDefect>>() {

            @Override
            public boolean matches(Optional<UsabilityDefect> usabilityGuidlineRecommendation) {
                return usabilityGuidlineRecommendation.get().getSeverityLevel().equals(UsabilityDefectSeverityLevel.INFO);
            }

        };
    }
    
    public static Condition<Optional<UsabilityDefect>> lowRecommendationSeverityLevel() {
        return new Condition<Optional<UsabilityDefect>>() {

            @Override
            public boolean matches(Optional<UsabilityDefect> usabilityGuidlineRecommendation) {
                return usabilityGuidlineRecommendation.get().getSeverityLevel().equals(UsabilityDefectSeverityLevel.LOW);
            }

        };
    }
    
    public static Condition<Optional<UsabilityDefect>> mediumRecommendationSeverityLevel() {
        return new Condition<Optional<UsabilityDefect>>() {

            @Override
            public boolean matches(Optional<UsabilityDefect> usabilityGuidlineRecommendation) {
                return usabilityGuidlineRecommendation.get().getSeverityLevel().equals(UsabilityDefectSeverityLevel.MEDIUM);
            }

        };
    }
    
    public static Condition<Optional<UsabilityDefect>> highRecommendationSeverityLevel() {
        return new Condition<Optional<UsabilityDefect>>() {

            @Override
            public boolean matches(Optional<UsabilityDefect> usabilityGuidlineRecommendation) {
                return usabilityGuidlineRecommendation.get().getSeverityLevel().equals(UsabilityDefectSeverityLevel.HIGH);
            }

        };
    }
    
}
