package de.ugoe.cs.autoquest.usability.util;

import java.util.Map;

import javax.annotation.Nullable;

import org.apache.commons.lang.StringUtils;

import lombok.AccessLevel;
import lombok.NoArgsConstructor;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;

import de.ugoe.cs.autoquest.usability.DefectDescription;
import de.ugoe.cs.autoquest.usability.ParameterFragment;

@NoArgsConstructor(access = AccessLevel.PRIVATE)
public class DefectDescriptionExtensionMethods {

    public static boolean containsParameterFragments(DefectDescription defectDescription) {
        return Iterables.any(defectDescription.getTextFragmentOrParameterFragment(), new Predicate<Object>() {

            @Override
            public boolean apply(@Nullable Object fragment) {
                return fragment instanceof ParameterFragment;
            }
            
        });
    }
    
    public static boolean isParameterFragment(Object object) {
        return object instanceof ParameterFragment;
    }
    
    public static String getValueOrEmptyString(Map<String, String> stringKeyValueMap, String key) {
        return stringKeyValueMap != null && stringKeyValueMap.containsKey(key) ? stringKeyValueMap.get(key) : StringUtils.EMPTY;
    }
    
}
