
package de.ugoe.cs.autoquest.plugin.html.eventcore;

import java.util.Map;
import java.util.logging.Level;

import de.ugoe.cs.autoquest.eventcore.IEventType;
import de.ugoe.cs.autoquest.eventcore.gui.IInteraction;
import de.ugoe.cs.autoquest.eventcore.gui.KeyboardFocusChange;
import de.ugoe.cs.autoquest.eventcore.gui.MouseButtonInteraction;
import de.ugoe.cs.autoquest.eventcore.gui.MouseClick;
import de.ugoe.cs.autoquest.eventcore.gui.Scroll;
import de.ugoe.cs.util.console.Console;

public class HTMLEventTypeFactory {
    private static HTMLEventTypeFactory instance = new HTMLEventTypeFactory();

    private HTMLEventTypeFactory() {}

    public static HTMLEventTypeFactory getInstance() {
        return instance;
    }

    public IEventType getEventType(String eventName, Map<String, String> eventParameters) {
        IInteraction result = null;

        if ("onscroll".equals(eventName)) {
            int[] coordinates = getCoordinateParameter(eventName, eventParameters);
            result = new Scroll(coordinates[0], coordinates[1]);
        }
        else if ("onclick".equals(eventName)) {
            int[] coordinates = getCoordinateParameter(eventName, eventParameters);
            result =
                new MouseClick(MouseButtonInteraction.Button.LEFT, coordinates[0], coordinates[1]);
        }
        else if ("onchange".equals(eventName)) {
            // TODO: Implement "onchange" event handling
            Console.traceln(Level.FINE, "Unhandled event of type \"" + eventName + "\"");
        }
        else if ("onfocus".equals(eventName)) {
            result = new KeyboardFocusChange();
        }
        else if ("onunload".equals(eventName) || "onbeforeunload".equals(eventName) ||
            "onpagehide".equals(eventName) || "onpageshow".equals(eventName))
        {
            Console.traceln(Level.FINE, "Ignored event name \"" + eventName + "\"");
        }
        else {
            throw new IllegalArgumentException("unknown event name: \"" + eventName + "\"");
        }
        return result;
    }

    /**
     * <p>
     * TODO: comment
     * </p>
     * 
     * @param eventName
     * @param eventParameters
     * @return
     */
    private int[] getCoordinateParameter(String eventName, Map<String, String> eventParameters) {
        String xCoord = eventParameters.get("X");
        if (xCoord == null) {
            throw new IllegalArgumentException("eventParameters do not contain X coordinate.");
        }

        String yCoord = eventParameters.get("Y");
        if (yCoord == null) {
            throw new IllegalArgumentException("eventParameters do not contain Y coordinate.");
        }

        try {
            return new int[]
                { Integer.parseInt(xCoord), Integer.parseInt(yCoord) };
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("the coordinates provided" + " of an " + eventName +
                " event are no numbers");
        }
    }
}
