//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.plugin;

import java.util.List;

/**
 * <p>
 * Interface for AutoQUEST plug-ins.
 * </p>
 * 
 * @author Steffen Herbold
 * @version 1.0
 */
public interface AutoQUESTPlugin {

	/**
	 * <p>
	 * Title of the plug-in.
	 * </p>
	 * 
	 * @return the title
	 */
	public String getTitle();

	/**
	 * <p>
	 * {@link List} of {@link String}s that contain the commands defined by this
	 * plug-in. The List is immutable.
	 * </p>
	 * <p>
	 * Consult the de.ugoe.cs.utils.console package of the java-utils project
	 * for more information.
	 * </p>
	 * 
	 * @return the command packages
	 */
	public List<String> getCommandPackages();
}
