
package de.ugoe.cs.autoquest.plugin.jfc;

import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;

import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;

import org.junit.Before;
import org.junit.Test;

import de.ugoe.cs.autoquest.eventcore.Event;
import de.ugoe.cs.autoquest.eventcore.guimodel.GUIModel;
import de.ugoe.cs.autoquest.eventcore.guimodel.IGUIElement;
import de.ugoe.cs.autoquest.plugin.jfc.guimodel.JFCGUIElement;
import de.ugoe.cs.util.console.TextConsole;

/**
 * TODO comment
 * 
 * @version $Revision: $ $Date: $
 * @author 2011, last modified by $Author: $
 */
public class JFCSimplifiedLogParserTest {

    /**
     *
     */
    @Before
    public void setUp() {
        new TextConsole(Level.FINEST);
    }

    /**
     * Test that parses regular log file.
     */
    @Test
    public void testParseRegularLog() throws Exception {
        JFCSimplifiedLogParser parser = new JFCSimplifiedLogParser(null);
        parser.parseFile(new File(ClassLoader.getSystemResource("freemind_regularTrace.xml")
                                  .getFile()));
        Collection<List<Event>> events = parser.getSequences();

        assertNotNull(events);
        assertTrue(events.size() > 0);

        System.err.println("{");
        for (List<Event> session : events) {
            System.err.println("  {");
            for (Event event : session) {
                System.err.print("    ");
                System.err.print(event);
                System.err.println(",");
            }
            System.err.println("  }");
        }
        System.err.println("}");
        System.err.println("\n\n");

        GUIModel guiModel = parser.getGuiModel();
        assertNotNull(guiModel);

        for (IGUIElement root : guiModel.getRootElements()) {
            dumpGUIElement(root, guiModel, "");
        }
    }

    /**
     * Test that parses a log file that contains events that have no registered targets when parsed.
     */
    @Test
    public void testParseLogEventsWithoutTargets() throws Exception {
        JFCSimplifiedLogParser parser = new JFCSimplifiedLogParser(null);
        parser.parseFile(new File(ClassLoader
                                  .getSystemResource("argouml_traceEventsWithoutTargets.xml").getFile()));
        Collection<List<Event>> events = parser.getSequences();

        assertNotNull(events);
        assertTrue(events.size() > 0);

        System.err.println("{");
        for (List<Event> session : events) {
            System.err.println("  {");
            for (Event event : session) {
                System.err.print("    ");
                System.err.print(event);
                System.err.println(",");
            }
            System.err.println("  }");
        }
        System.err.println("}");
        System.err.println("\n\n");

        GUIModel guiModel = parser.getGuiModel();
        assertNotNull(guiModel);

        for (IGUIElement root : guiModel.getRootElements()) {
            dumpGUIElement(root, guiModel, "");
        }
    }

    /**
     * TODO: comment
     * 
     * @param root
     * @param guiModel
     */
    private void dumpGUIElement(IGUIElement guiElement, GUIModel guiModel, String indent) {
        assertTrue(guiElement instanceof JFCGUIElement);

        System.err.print(indent);
        System.err.print(guiElement);

        List<IGUIElement> children = guiModel.getChildren(guiElement);

        if ((children != null) && (children.size() > 0)) {
            System.err.println(" {");

            for (IGUIElement child : children) {
                dumpGUIElement(child, guiModel, indent + "  ");
            }

            System.err.print(indent);
            System.err.print("}");
        }

        System.err.println();
    }

}
