//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.plugin.html.guimodel;

import java.net.URL;

import de.ugoe.cs.autoquest.eventcore.guimodel.IGUIElementSpec;

/**
 * <p>
 * TODO comment
 * </p>
 * 
 * @author Patrick Harms
 */
public class HTMLServerSpec extends HTMLGUIElementSpec implements IGUIElementSpec {

    /**  */
    private static final long serialVersionUID = 1L;
    
    /** */
    private String host;
    
    /** */
    private int port;

    /**
     * <p>
     * TODO: comment
     * </p>
     *
     * @param serverName
     * @param port
     */
    public HTMLServerSpec(String host, int port) {
        super("server");
        
        if (host == null) {
            throw new IllegalArgumentException("host must not be null");
        }
        
        if ((port < -1) || (port > 65536)) {
            throw new IllegalArgumentException("port " + port + " is not a valid port");
        }

        this.host = host;
        this.port = port;
    }

    /**
     * <p>
     * TODO: comment
     * </p>
     *
     * @param pageURL
     */
    public HTMLServerSpec(URL pageURL) {
        super("server");

        if (pageURL == null) {
            throw new IllegalArgumentException("page URL must not be null");
        }

        this.host = pageURL.getHost();
        this.port = pageURL.getPort();
    }

    /* (non-Javadoc)
     * @see de.ugoe.cs.autoquest.eventcore.guimodel.IGUIElementSpec#getSimilarity(IGUIElementSpec)
     */
    @Override
    public boolean getSimilarity(IGUIElementSpec other) {
        if (other instanceof HTMLServerSpec) {
            HTMLServerSpec otherSpec = (HTMLServerSpec) other;
            
            if (!super.getSimilarity(otherSpec)) {
                return false;
            }
            else if (!host.equals(otherSpec.host)) {
                return false;
            }
            else {
                return (port == otherSpec.port);
            }
        }
        
        return false;
    }

    /**
     * <p>
     * TODO: comment
     * </p>
     *
     * @return
     */
    String getHost() {
        return this.host;
    }

    /**
     * <p>
     * TODO: comment
     * </p>
     *
     * @return
     */
    int getPort() {
        return this.port;
    }

}
