/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.bcel;

import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.DescriptorFactory;
import edu.umd.cs.findbugs.classfile.FieldDescriptor;
import edu.umd.cs.findbugs.classfile.MethodDescriptor;
import edu.umd.cs.findbugs.internalAnnotations.DottedClassName;
import edu.umd.cs.findbugs.util.ClassName;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.FieldInstruction;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.ObjectType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BCELUtil {
    private static final int JDK15_MAJOR = 48;
    private static final int JDK15_MINOR = 0;

    public static MethodDescriptor getMethodDescriptor(JavaClass jclass, Method method) {
        return DescriptorFactory.instance().getMethodDescriptor(jclass.getClassName().replace('.', '/'), method.getName(), method.getSignature(), method.isStatic());
    }

    public static MethodDescriptor getCalledMethodDescriptor(InvokeInstruction inv, ConstantPoolGen cpg) {
        String calledClassName = inv.getClassName(cpg).replace('.', '/');
        String calledMethodName = inv.getMethodName(cpg);
        String calledMethodSig = inv.getSignature(cpg);
        boolean isStatic = inv.getOpcode() == 184;
        return DescriptorFactory.instance().getMethodDescriptor(calledClassName, calledMethodName, calledMethodSig, isStatic);
    }

    public static FieldDescriptor getAccessedFieldDescriptor(FieldInstruction fins, ConstantPoolGen cpg) {
        String className = fins.getClassName(cpg);
        String fieldName = fins.getName(cpg);
        String fieldSig = fins.getSignature(cpg);
        boolean isStatic = fins.getOpcode() == 178 || fins.getOpcode() == 179;
        return DescriptorFactory.instance().getFieldDescriptor(className, fieldName, fieldSig, isStatic);
    }

    public static ClassDescriptor getClassDescriptor(JavaClass jclass) {
        return DescriptorFactory.instance().getClassDescriptor(ClassName.toSlashedClassName(jclass.getClassName()));
    }

    public static boolean preTiger(JavaClass jclass) {
        return jclass.getMajor() < 48 || jclass.getMajor() == 48 && jclass.getMinor() < 0;
    }

    @Deprecated
    public static ClassDescriptor getClassDescriptor(ObjectType type) {
        return DescriptorFactory.getClassDescriptor(type);
    }

    @Deprecated
    public static void throwClassNotFoundException(ClassDescriptor classDescriptor) throws ClassNotFoundException {
        ClassDescriptor.throwClassNotFoundException(classDescriptor);
    }

    public static ObjectType getObjectTypeInstance(@DottedClassName String className) {
        return ObjectType.getInstance(className);
    }

    public static ObjectType getObjectTypeInstance(Class<?> clazz) {
        return BCELUtil.getObjectTypeInstance(clazz.getName());
    }
}

