/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba.jsr305;

import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.MissingClassException;
import edu.umd.cs.findbugs.ba.XClass;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.ba.jsr305.ValidatorClassLoader;
import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.DescriptorFactory;
import edu.umd.cs.findbugs.classfile.Global;
import edu.umd.cs.findbugs.classfile.IAnalysisCache;
import edu.umd.cs.findbugs.classfile.analysis.ClassData;
import edu.umd.cs.findbugs.log.Profiler;
import edu.umd.cs.findbugs.util.DualKeyHashMap;
import edu.umd.cs.findbugs.util.Util;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.security.Permission;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.meta.Exclusive;
import javax.annotation.meta.Exhaustive;
import javax.annotation.meta.TypeQualifierValidator;
import javax.annotation.meta.When;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeQualifierValue<A extends Annotation> {
    public static final boolean DEBUG = SystemProperties.getBoolean("tqv.debug");
    private static final ClassDescriptor EXCLUSIVE_ANNOTATION = DescriptorFactory.instance().getClassDescriptor(Exclusive.class);
    private static final ClassDescriptor EXHAUSTIVE_ANNOTATION = DescriptorFactory.instance().getClassDescriptor(Exhaustive.class);
    public final ClassDescriptor typeQualifier;
    public final Class<A> typeQualifierClass;
    public final A proxy;
    @CheckForNull
    public final Object value;
    private final boolean isStrict;
    private final boolean isExclusive;
    private final boolean isExhaustive;
    @CheckForNull
    private final TypeQualifierValidator<A> validator;
    private static final ClassLoader validatorLoader = new ValidatorClassLoader();
    private static ThreadLocal<Data> instance = new ThreadLocal<Data>(){

        @Override
        protected Data initialValue() {
            return new Data();
        }
    };
    private static final InheritableThreadLocal<AtomicBoolean> performingValidation = new InheritableThreadLocal<AtomicBoolean>(){

        @Override
        protected AtomicBoolean initialValue() {
            return new AtomicBoolean();
        }
    };

    private TypeQualifierValue(ClassDescriptor typeQualifier, @CheckForNull Object value) {
        this.typeQualifier = typeQualifier;
        this.value = value;
        boolean isStrict = false;
        boolean isExclusive = false;
        boolean isExhaustive = false;
        TypeQualifierValidator validator = null;
        Class<?> qualifierClass = null;
        Annotation proxy = null;
        try {
            XClass xclass = Global.getAnalysisCache().getClassAnalysis(XClass.class, typeQualifier);
            XMethod whenMethod = xclass.findMethod("when", "()Ljavax/annotation/meta/When;", false);
            if (whenMethod == null) {
                isStrict = true;
            }
            for (XMethod xMethod : xclass.getXMethods()) {
                if (!xMethod.getName().equals("value") || !xMethod.getSignature().startsWith("()")) continue;
                boolean bl = isExhaustive = xMethod.getAnnotation(EXHAUSTIVE_ANNOTATION) != null;
                isExclusive = isExhaustive ? true : xMethod.getAnnotation(EXCLUSIVE_ANNOTATION) != null;
                break;
            }
        }
        catch (MissingClassException e) {
            AnalysisContext.currentAnalysisContext().getLookupFailureCallback().reportMissingClass(e.getClassNotFoundException());
        }
        catch (CheckedAnalysisException e) {
            AnalysisContext.logError("Error looking up annotation class " + typeQualifier.toDottedClassName(), e);
        }
        this.isStrict = isStrict;
        this.isExclusive = isExclusive;
        this.isExhaustive = isExhaustive;
        ClassDescriptor checkerName = DescriptorFactory.createClassDescriptor(typeQualifier.getClassName() + "$Checker");
        try {
            Class<?> c;
            Global.getAnalysisCache().getClassAnalysis(ClassData.class, checkerName);
            SecurityManager m = System.getSecurityManager();
            if (m == null) {
                System.setSecurityManager(new ValidationSecurityManager());
            }
            if (TypeQualifierValidator.class.isAssignableFrom(c = validatorLoader.loadClass(checkerName.getDottedClassName()))) {
                Class<TypeQualifierValidator> clazz = c.asSubclass(TypeQualifierValidator.class);
                validator = clazz.newInstance();
                qualifierClass = validatorLoader.loadClass(typeQualifier.getDottedClassName());
                InvocationHandler handler = new InvocationHandler(){

                    public Object invoke(Object arg0, Method arg1, Object[] arg2) throws Throwable {
                        if (arg1.getName() == "value") {
                            return TypeQualifierValue.this.value;
                        }
                        throw new UnsupportedOperationException("Can't handle " + arg1);
                    }
                };
                proxy = (Annotation)qualifierClass.cast(Proxy.newProxyInstance(validatorLoader, new Class[]{qualifierClass}, handler));
            }
        }
        catch (ClassNotFoundException e) {
        }
        catch (CheckedAnalysisException e) {
        }
        catch (InstantiationException e) {
            AnalysisContext.logError("Unable to construct type qualifier checker " + checkerName, e);
        }
        catch (IllegalAccessException e) {
            AnalysisContext.logError("Unable to construct type qualifier checker " + checkerName, e);
        }
        this.validator = validator;
        this.typeQualifierClass = qualifierClass;
        this.proxy = proxy;
    }

    public static void clearInstance() {
        instance.remove();
    }

    public boolean canValidate(Object constantValue) {
        return this.validator != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public When validate(Object constantValue) {
        if (this.validator == null) {
            throw new IllegalStateException("No validator");
        }
        IAnalysisCache analysisCache = Global.getAnalysisCache();
        Profiler profiler = analysisCache.getProfiler();
        profiler.start(this.validator.getClass());
        AtomicBoolean performing = (AtomicBoolean)performingValidation.get();
        try {
            if (!performing.compareAndSet(false, true)) {
                throw new IllegalStateException("recursive validation");
            }
            When when = this.validator.forConstantValue(this.proxy, constantValue);
            return when;
        }
        catch (Exception e) {
            AnalysisContext.logError("Error executing custom validator for " + this.typeQualifier + " " + constantValue, e);
            When when = When.UNKNOWN;
            return when;
        }
        finally {
            if (!performing.compareAndSet(true, false)) {
                throw new IllegalStateException("performingValidation not set when validation completes");
            }
            profiler.end(this.validator.getClass());
        }
    }

    @Nonnull
    public static TypeQualifierValue getValue(ClassDescriptor desc, Object value) {
        DualKeyHashMap<ClassDescriptor, Object, TypeQualifierValue> map = TypeQualifierValue.instance.get().typeQualifierMap;
        TypeQualifierValue result = map.get(desc, value);
        if (result != null) {
            return result;
        }
        result = new TypeQualifierValue(desc, value);
        map.put(desc, value, result);
        TypeQualifierValue.instance.get().allKnownTypeQualifiers.add(result);
        return result;
    }

    public static Collection<TypeQualifierValue> getAllKnownTypeQualifiers() {
        return Collections.unmodifiableSet(TypeQualifierValue.instance.get().allKnownTypeQualifiers);
    }

    public static Collection<TypeQualifierValue> getComplementaryExclusiveTypeQualifierValue(TypeQualifierValue tqv) {
        assert (tqv.isExclusiveQualifier());
        LinkedList<TypeQualifierValue> result = new LinkedList<TypeQualifierValue>();
        for (TypeQualifierValue t : TypeQualifierValue.instance.get().allKnownTypeQualifiers) {
            if (!t.typeQualifier.equals(tqv.typeQualifier) || Util.nullSafeEquals(t.value, tqv.value)) continue;
            result.add(t);
        }
        return result;
    }

    public static boolean hasMultipleVariants(TypeQualifierValue tqv) {
        int count = 0;
        for (TypeQualifierValue t : TypeQualifierValue.instance.get().allKnownTypeQualifiers) {
            if (!t.typeQualifier.equals(tqv.typeQualifier)) continue;
            ++count;
        }
        return count > 1;
    }

    public ClassDescriptor getTypeQualifierClassDescriptor() {
        return this.typeQualifier;
    }

    public boolean isStrictQualifier() {
        return this.isStrict;
    }

    public boolean isExclusiveQualifier() {
        return this.isExclusive;
    }

    public boolean isExhaustiveQualifier() {
        return this.isExhaustive;
    }

    public int hashCode() {
        int result = this.typeQualifier.hashCode();
        if (this.value != null) {
            result += 37 * this.value.hashCode();
        }
        return result;
    }

    public boolean equals(Object o) {
        if (!(o instanceof TypeQualifierValue)) {
            return false;
        }
        TypeQualifierValue other = (TypeQualifierValue)o;
        return this.typeQualifier.equals(other.typeQualifier) && Util.nullSafeEquals(this.value, other.value);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.typeQualifier.toString());
        if (this.value != null) {
            buf.append(':');
            buf.append(this.value.toString());
        }
        return buf.toString();
    }

    static final class ValidationSecurityManager
    extends SecurityManager {
        ValidationSecurityManager() {
        }

        public void checkPermission(Permission perm) {
            if (((AtomicBoolean)performingValidation.get()).get()) {
                throw new SecurityException("not permissions granted while performing JSR-305 validation");
            }
        }

        public void checkPermission(Permission perm, Object context) {
            if (((AtomicBoolean)performingValidation.get()).get()) {
                throw new SecurityException("not permissions granted while performing JSR-305 validation");
            }
        }
    }

    static class Data {
        DualKeyHashMap<ClassDescriptor, Object, TypeQualifierValue> typeQualifierMap = new DualKeyHashMap();
        Set<TypeQualifierValue> allKnownTypeQualifiers = new HashSet<TypeQualifierValue>();

        Data() {
        }
    }
}

