/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugAccumulator;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import org.apache.bcel.classfile.Code;

public class TestingGround
extends OpcodeStackDetector {
    final BugReporter bugReporter;
    final BugAccumulator accumulator;

    public TestingGround(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
        this.accumulator = new BugAccumulator(bugReporter);
    }

    public void visit(Code code) {
        boolean interesting = true;
        if (interesting) {
            super.visit(code);
        }
        this.accumulator.reportAccumulatedBugs();
    }

    public void sawOpcode(int seen) {
        switch (seen) {
            case 159: 
            case 160: {
                OpcodeStack.Item left = this.stack.getStackItem(1);
                OpcodeStack.Item right = this.stack.getStackItem(0);
                if (!this.bad(left, right) && !this.bad(right, left)) break;
                this.accumulator.accumulateBug(new BugInstance(this, "TESTING", 2).addClassAndMethod(this).addValueSource(left, this).addValueSource(right, this), this);
            }
        }
    }

    private boolean bad(OpcodeStack.Item left, OpcodeStack.Item right) {
        XMethod m = left.getReturnValueOf();
        if (m == null) {
            return false;
        }
        Object value = right.getConstant();
        if (!(value instanceof Integer) && (Integer)value == 0) {
            return false;
        }
        if (m.isStatic() || !m.isPublic()) {
            return false;
        }
        if (m.getName().equals("compareTo") && m.getSignature().equals("(Ljava/lang/Object;)I")) {
            return true;
        }
        return m.getName().equals("compare") && m.getSignature().equals("(Ljava/lang/Object;Ljava/lang/Object;)I");
    }
}

