//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.plugin.html;

import static org.junit.Assert.*;

import java.io.File;
import java.util.Collection;
import java.util.List;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;

import de.ugoe.cs.autoquest.eventcore.Event;
import de.ugoe.cs.autoquest.eventcore.guimodel.GUIModel;
import de.ugoe.cs.autoquest.eventcore.guimodel.IGUIElement;
import de.ugoe.cs.autoquest.plugin.html.guimodel.HTMLGUIElement;
import de.ugoe.cs.util.console.TextConsole;

/**
 *
 * @author Patrick Harms
 */
public class OldHTMLLogParserTest {

    /**
     *
     */
    @Before
    public void setUp() throws Exception {
        new TextConsole();
    }

    /**
     *
     */
    @After
    public void tearDown() throws Exception {}

    /**
     *
     */
    @Test
    public void test() {
        OldHTMLLogParser parser = new OldHTMLLogParser();
        parser.parseFile(new File(ClassLoader.getSystemResource("trace.txt").getFile()));
        Collection<List<Event>> events = parser.getSequences();

        assertNotNull(events);
        assertTrue(events.size() > 0);

        System.err.println("{");
        for (List<Event> session : events) {
            System.err.println("  {");
            for (Event event : session) {
                System.err.print("    ");
                assertTrue(event instanceof Event);
                System.err.print(event);
                System.err.println(",");
            }
            System.err.println("  }");
        }
        System.err.println("}");
        System.err.println("\n\n");

        GUIModel guiModel = parser.getGuiModel();
        assertNotNull(guiModel);
        guiModel.condenseModel();

        for (IGUIElement root : guiModel.getRootElements()) {
            dumpGUIElement(root, guiModel, "");
        }
    }
    
    /**
     * TODO: comment
     * 
     * @param root
     * @param guiModel
     */
    private void dumpGUIElement(IGUIElement guiElement, GUIModel guiModel, String indent) {
        assertTrue(guiElement instanceof HTMLGUIElement);

        System.err.print(indent);
        System.err.print(guiElement);

        List<IGUIElement> children = guiModel.getChildren(guiElement);

        if ((children != null) && (children.size() > 0)) {
            System.err.println(" {");

            for (IGUIElement child : children) {
                dumpGUIElement(child, guiModel, indent + "  ");
            }

            System.err.print(indent);
            System.err.print("}");
        }

        System.err.println();
    }

}
