//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.plugin.html;

import static org.junit.Assert.*;

import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;

import org.junit.Before;
import org.junit.Test;

import de.ugoe.cs.autoquest.eventcore.Event;
import de.ugoe.cs.autoquest.eventcore.guimodel.GUIModel;
import de.ugoe.cs.autoquest.eventcore.guimodel.IGUIElement;
import de.ugoe.cs.autoquest.plugin.html.guimodel.HTMLGUIElement;
import de.ugoe.cs.util.console.TextConsole;

/**
 * Test for the new HTMLLogParser
 * @author Fabian Glaser
 *
 */
public class HTMLLogParserTest {

    /**
    *
    */
   @Before
   public void setUp() {
       new TextConsole(Level.FINEST);
   }

   
   /**
    * Tests the parseFile method with a given trace file.
    * @throws Exception
    */
   @Test
   public void testParseFile() throws Exception {
       HTMLLogParser parser = new HTMLLogParser();
       parser.parseFile(new File(ClassLoader.getSystemResource("htmlmonitor_testtrace.xml").getFile()));
       Collection<List<Event>> events = parser.getSequences();

       assertNotNull(events);
       assertTrue(events.size() > 0);

       System.err.println("{");
       for (List<Event> session : events) {
           System.err.println("  {");
           for (Event event : session) {
               System.err.print("    ");
               System.err.print(event);
               System.err.println(",");
           }
           System.err.println("  }");
       }
       System.err.println("}");
       System.err.println("\n\n");

       GUIModel guiModel = parser.getGuiModel();
       assertNotNull(guiModel);

       for (IGUIElement root : guiModel.getRootElements()) {
           dumpGUIElement(root, guiModel, "");
       }
   }

   /**
    * Helper method to print out GUIElements
    * @param guiElement
    * @param guiModel
    * @param indent
    */
   private void dumpGUIElement(IGUIElement guiElement, GUIModel guiModel, String indent) {
       assertTrue(guiElement instanceof HTMLGUIElement);

       System.err.print(indent);
       System.err.print(guiElement);

       List<IGUIElement> children = guiModel.getChildren(guiElement);

       if ((children != null) && (children.size() > 0)) {
           System.err.println(" {");

           for (IGUIElement child : children) {
               dumpGUIElement(child, guiModel, indent + "  ");
           }

           System.err.print(indent);
           System.err.print("}");
       }

       System.err.println();
   }

}
