//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.usability.testutil;

import org.fest.assertions.core.Condition;

import com.google.common.base.Optional;

import de.ugoe.cs.autoquest.usability.UsabilityEvaluationReport;
import de.ugoe.cs.autoquest.usability.evaluation.result.UsabilityDefectSeverityLevel;
import de.ugoe.cs.autoquest.usability.evaluation.result.UsabilityDefect;
import de.ugoe.cs.autoquest.usability.evaluation.rule.set.UsabilityRuleset;

/**
 * <p>
 * TODO comment
 * </p>
 * 
 * @author Alexander Deicke
 */
public class FestConditionUtil {

    private FestConditionUtil() {
        // no good idea
    }

    public static Condition<UsabilityEvaluationReport> noUsabilityGuidlineRecommendations() {
        return new Condition<UsabilityEvaluationReport>() {

            @Override
            public boolean matches(UsabilityEvaluationReport usabilityEvaluationReport) {
                return usabilityEvaluationReport.evaluationResults().isEmpty();
            }
        };
    }

    public static Condition<UsabilityEvaluationReport> usabilityGuidlineRecommendations() {
        return new Condition<UsabilityEvaluationReport>() {

            @Override
            public boolean matches(UsabilityEvaluationReport usabilityEvaluationReport) {
                return !usabilityEvaluationReport.evaluationResults().isEmpty();
            }
        };
    }

    public static Condition<UsabilityRuleset> noUsabilityRules() {
        return new Condition<UsabilityRuleset>() {

            @Override
            public boolean matches(UsabilityRuleset usabilityRuleset) {
                return usabilityRuleset.evaluationRules().isEmpty();
            }

        };
    }

    public static Condition<UsabilityRuleset> usabilityRules() {
        return new Condition<UsabilityRuleset>() {

            @Override
            public boolean matches(UsabilityRuleset usabilityRuleset) {
                return !usabilityRuleset.evaluationRules().isEmpty();
            }

        };
    }

    public static Condition<Optional<UsabilityDefect>> present() {
        return new Condition<Optional<UsabilityDefect>>() {

            @Override
            public boolean matches(Optional<UsabilityDefect> usabilityGuidlineRecommendation) {
                return usabilityGuidlineRecommendation.isPresent();
            }

        };
    }

    public static Condition<Optional<UsabilityDefect>> absent() {
        return new Condition<Optional<UsabilityDefect>>() {

            @Override
            public boolean matches(Optional<UsabilityDefect> usabilityGuidlineRecommendation) {
                return !usabilityGuidlineRecommendation.isPresent();
            }

        };
    }

    public static Condition<Optional<UsabilityDefect>> infoRecommendationSeverityLevel() {
        return new Condition<Optional<UsabilityDefect>>() {

            @Override
            public boolean matches(Optional<UsabilityDefect> usabilityGuidlineRecommendation) {
                return usabilityGuidlineRecommendation.get().getSeverityLevel()
                    .equals(UsabilityDefectSeverityLevel.INFO);
            }

        };
    }

    public static Condition<Optional<UsabilityDefect>> lowRecommendationSeverityLevel() {
        return new Condition<Optional<UsabilityDefect>>() {

            @Override
            public boolean matches(Optional<UsabilityDefect> usabilityGuidlineRecommendation) {
                return usabilityGuidlineRecommendation.get().getSeverityLevel()
                    .equals(UsabilityDefectSeverityLevel.LOW);
            }

        };
    }

    public static Condition<Optional<UsabilityDefect>> mediumRecommendationSeverityLevel() {
        return new Condition<Optional<UsabilityDefect>>() {

            @Override
            public boolean matches(Optional<UsabilityDefect> usabilityGuidlineRecommendation) {
                return usabilityGuidlineRecommendation.get().getSeverityLevel()
                    .equals(UsabilityDefectSeverityLevel.MEDIUM);
            }

        };
    }

    public static Condition<Optional<UsabilityDefect>> highRecommendationSeverityLevel() {
        return new Condition<Optional<UsabilityDefect>>() {

            @Override
            public boolean matches(Optional<UsabilityDefect> usabilityGuidlineRecommendation) {
                return usabilityGuidlineRecommendation.get().getSeverityLevel()
                    .equals(UsabilityDefectSeverityLevel.HIGH);
            }

        };
    }

}
