//   Copyright 2012 Georg-August-Universität Göttingen, Germany
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

package de.ugoe.cs.autoquest.eventcore.gui;

/**
 * <p>
 * Event type for selecting a value.
 * </p>
 * 
 * @version 1.0
 * @author Patrick Harms
 */
public class ValueSelection<T> implements IInteraction {

    /**
     * <p>
     * Id for object serialization.
     * </p>
     */
    private static final long serialVersionUID = 1L;

    /**
     * <p>
     * The selected value.
     * </p>
     */
    private T selectedValue;

    /**
     * <p>
     * Constructor. Creates a new ValueSelection.
     * </p>
     * 
     * @param selectedValue
     *            the selected value
     */
    public ValueSelection(T selectedValue) {
        this.selectedValue = selectedValue;
    }

    /*
     * (non-Javadoc)
     * 
     * @see de.harms.attef.userinteraction.Interaction#getName()
     */
    public String getName() {
        String result = "ValueSelection";
        
        if (selectedValue != null) {
            result += "(\"" + selectedValue + "\")";
        }
        
        return result;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        String result = "select value";
        
        if (selectedValue != null) {
            result += " \"" + selectedValue + "\"";
        }
        
        return result;
    }

    /*
     * (non-Javadoc)
     * 
     * @see de.harms.attef.userinteraction.Interaction#startsLogicalSequence()
     */
    public boolean startsLogicalSequence() {
        return false;
    }

    /*
     * (non-Javadoc)
     * 
     * @see de.harms.attef.userinteraction.Interaction#finishesLogicalSequence()
     */
    public boolean finishesLogicalSequence() {
        return false;
    }

    /**
     * <p>
     * Returns the selected value associated with this event.
     * </p>
     * 
     * @return the selectedValue
     */
    public T getSelectedValue() {
        return selectedValue;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#equals(java.lang.Object)
     */
    @Override
    public boolean equals(Object obj) {
        if ((obj == null) || (!(obj instanceof ValueSelection<?>))) {
            return false;
        }

        ValueSelection<?> otherValueSelection = (ValueSelection<?>) obj;

        return ((otherValueSelection != null) && ((selectedValue == otherValueSelection.selectedValue) || ((selectedValue != null) && (selectedValue
            .equals(otherValueSelection.selectedValue)))));
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#hashCode()
     */
    @Override
    public int hashCode() {
        return selectedValue.hashCode();
    }

}
